package cn.allbs.websocket.handler;

import cn.allbs.common.enums.WebSocketResponseEnum;
import cn.allbs.websocket.behavior.SendToAllUserRequest;
import cn.allbs.websocket.message.MessageFactory;
import cn.allbs.websocket.util.WebSocketSessionManager;
import cn.allbs.websocket.util.WebSocketUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.socket.WebSocketSession;

import static cn.allbs.websocket.enums.MessageType.ONLINE_USER_NAME_LIST;

/**
 * 获取所有在线用户信息
 *
 * @author ChenQi
 */
public class GetAllOnlineUserHandler implements MessageHandler<SendToAllUserRequest>, InitializingBean {
    @Override
    public void execute(WebSocketSession session, SendToAllUserRequest message) {
        SendToAllUserRequest allUser = SendToAllUserRequest.builder().userList(WebSocketSessionManager.getAllUserName()).build();
        WebSocketUtil.send(session, WebSocketResponseEnum.ONLINE_USER_LIST, allUser);
    }

    @Override
    public void afterPropertiesSet() {
        MessageFactory.register(ONLINE_USER_NAME_LIST.name(), this);
    }
}
