/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.websocket.util;

import cn.allbs.common.enums.WebSocketResponseEnum;
import cn.allbs.websocket.message.Message;
import cn.allbs.websocket.util.WebSocketSessionManager;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public final class WebSocketUtil {
    private static final Logger log = LoggerFactory.getLogger(WebSocketUtil.class);

    public static void addSession(WebSocketSession session, String userName) {
        WebSocketSessionManager.add(userName, session);
    }

    public static void removeSession(WebSocketSession session) {
        Object user = session.getAttributes().get("userName");
        if (ObjectUtil.isNotEmpty(user)) {
            WebSocketSessionManager.remove(user.toString());
        }
    }

    public static <T extends Message> void broadcast(WebSocketResponseEnum webSocketResponseEnum, T data) {
        WebSocketUtil.broadcast(webSocketResponseEnum.getCode().toString(), webSocketResponseEnum.getMsg(), data);
    }

    public static <T extends Message> void broadcast(String code, String msg, T data) {
        JSONObject json = new JSONObject();
        json.putOpt("code", (Object)code);
        json.putOpt("msg", (Object)msg);
        json.putOpt("data", data);
        TextMessage textMessage = new TextMessage((CharSequence)json.toString());
        WebSocketSessionManager.getAll().forEach(session -> WebSocketUtil.sendTextMessage(session, textMessage));
    }

    public static <T extends Message> void broadcastWithoutSelf(WebSocketResponseEnum webSocketResponseEnum, T data, String userName) {
        WebSocketUtil.broadcastWithoutSelf(webSocketResponseEnum.getCode().toString(), webSocketResponseEnum.getMsg(), data, userName);
    }

    public static <T extends Message> void broadcastWithoutSelf(String code, String msg, T data, String userName) {
        JSONObject json = new JSONObject();
        json.putOpt("code", (Object)code);
        json.putOpt("msg", (Object)msg);
        json.putOpt("data", data);
        TextMessage textMessage = new TextMessage((CharSequence)json.toString());
        WebSocketSessionManager.getAll().stream().filter(a -> !a.equals(WebSocketSessionManager.get(userName))).forEach(session -> WebSocketUtil.sendTextMessage(session, textMessage));
    }

    public static <T extends Message> void send(WebSocketSession session, WebSocketResponseEnum webSocketResponseEnum, T data) {
        WebSocketUtil.send(session, webSocketResponseEnum.getCode().toString(), webSocketResponseEnum.getMsg(), data);
    }

    public static <T extends Message> void send(WebSocketSession session, String code, String msg, T data) {
        JSONObject json = new JSONObject();
        json.putOpt("code", (Object)code);
        json.putOpt("msg", (Object)msg);
        json.putOpt("data", data);
        TextMessage textMessage = new TextMessage((CharSequence)json.toString());
        WebSocketUtil.sendTextMessage(session, textMessage);
    }

    public static <T extends Message> boolean send(String userName, String code, String msg, T data) {
        WebSocketSession session = WebSocketSessionManager.get(userName);
        if (session == null) {
            log.error("{}\u7528\u6237\u4e0d\u5728\u7ebf", (Object)userName);
            return false;
        }
        WebSocketUtil.send(session, code, msg, data);
        return true;
    }

    public static <T extends Message> boolean send(String userName, WebSocketResponseEnum webSocketResponseEnum, T data) {
        return WebSocketUtil.send(userName, webSocketResponseEnum.getCode().toString(), webSocketResponseEnum.getMsg(), data);
    }

    private static void sendTextMessage(WebSocketSession session, TextMessage textMessage) {
        if (session == null) {
            log.debug("[sendTextMessage][session \u4e3a null]");
            return;
        }
        try {
            session.sendMessage((WebSocketMessage)textMessage);
        }
        catch (IOException e) {
            log.debug("[sendTextMessage][session({}) \u53d1\u9001\u6d88\u606f{}) \u53d1\u751f\u5f02\u5e38", new Object[]{session, textMessage, e});
        }
    }

    private WebSocketUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

