/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.websocket.util;

import cn.hutool.core.date.DateUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketSession;

public class WebSocketSessionManager {
    private static final Logger log = LoggerFactory.getLogger(WebSocketSessionManager.class);
    private static final Map<String, WebSocketSession> SESSION_POOL = new ConcurrentHashMap<String, WebSocketSession>();
    private static int onlineCount = 0;

    public static void add(String userName, WebSocketSession session) {
        log.info(DateUtil.now() + "\u65b0\u589e\u8fde\u63a5,\u8fde\u63a5\u7528\u6237\u4e3a" + userName);
        WebSocketSessionManager.addOnlineCount();
        SESSION_POOL.put(userName, session);
    }

    public static WebSocketSession remove(String userName) {
        WebSocketSessionManager.subOnlineCount();
        return SESSION_POOL.remove(userName);
    }

    public static void removeAndClose(String userName) {
        WebSocketSession session = WebSocketSessionManager.remove(userName);
        if (session != null) {
            try {
                session.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static WebSocketSession get(String userName) {
        return SESSION_POOL.get(userName);
    }

    public static List<WebSocketSession> getAll() {
        ArrayList<WebSocketSession> list = new ArrayList<WebSocketSession>();
        SESSION_POOL.forEach((k, v) -> list.add((WebSocketSession)v));
        return list;
    }

    public static List<String> getAllUserName() {
        ArrayList<String> userList = new ArrayList<String>();
        SESSION_POOL.forEach((k, v) -> userList.add((String)k));
        return userList;
    }

    public static synchronized int getOnlineCount() {
        return onlineCount;
    }

    public static synchronized void addOnlineCount() {
        ++onlineCount;
    }

    public static synchronized void subOnlineCount() {
        --onlineCount;
    }
}

