/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.websocket.handler;

import cn.allbs.common.enums.WebSocketResponseEnum;
import cn.allbs.websocket.behavior.SendResponse;
import cn.allbs.websocket.behavior.SendToOneRequest;
import cn.allbs.websocket.enums.MessageType;
import cn.allbs.websocket.handler.MessageHandler;
import cn.allbs.websocket.message.MessageFactory;
import cn.allbs.websocket.util.WebSocketUtil;
import cn.hutool.core.util.StrUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.socket.WebSocketSession;

public class PushToOneUserHandler
implements MessageHandler<SendToOneRequest>,
InitializingBean {
    @Override
    public void execute(WebSocketSession session, SendToOneRequest message) {
        if (!StrUtil.isAllNotEmpty((CharSequence[])new CharSequence[]{message.getToUserName(), message.getContent()})) {
            SendResponse sendResponse = SendResponse.builder().content("\u6307\u5b9a\u7528\u6237\u540d\u79f0\u53ca\u53d1\u9001\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a").build();
            WebSocketUtil.send(session, WebSocketResponseEnum.RESPONSE_FAILURE, sendResponse);
            return;
        }
        if (WebSocketUtil.send(message.getToUserName(), WebSocketResponseEnum.RESPONSE_SUCCESS, SendResponse.builder().content(message.getContent()).build())) {
            SendResponse sendResponse = SendResponse.builder().content("\u6d88\u606f\u53d1\u9001\u6210\u529f").build();
            WebSocketUtil.send(session, WebSocketResponseEnum.SEND_TO_ONE, sendResponse);
            return;
        }
        SendResponse sendResponse = SendResponse.builder().content("\u6d88\u606f\u53d1\u9001\u5931\u8d25,\u6307\u5b9a\u7528\u6237\u4e0d\u5728\u7ebf\uff01").build();
        WebSocketUtil.send(session, WebSocketResponseEnum.RESPONSE_FAILURE, sendResponse);
    }

    public void afterPropertiesSet() {
        MessageFactory.register(MessageType.SEND_TO_ONE_REQUEST.name(), this);
    }
}

