package cn.allbs.websocket.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author ChenQi
 */
@Getter
@AllArgsConstructor
public enum MessageType {

    /**
     * 用户认证请求
     */
    AUTH_REQUEST,

    /**
     * 用户认证响应
     */
    AUTH_RESPONSE,

    /**
     * 发送消息响应结果
     */
    SEND_RESPONSE,

    /**
     * 发送给所又人的群聊消息
     */
    SEND_TO_ALL_REQUEST,

    /**
     * 发送给指定用户的消息
     */
    SEND_TO_ONE_REQUEST,

    /**
     * 发送给另外一个用户的消息
     */
    SEND_TO_USER_REQUEST,

    /**
     * 用户加入群聊的通知
     */
    USER_JOIN_NOTICE_REQUEST,

    /**
     * 系统默认消息
     */
    SYS_DEFAULT_REQUEST,

    /**
     * 用户自定义消息
     */
    CUSTOM_DEFAULT_REQUEST,

    /**
     * 所有用户数量统计
     */
    TOTAL_USER_COUNT,

    /**
     * 所有在线用户名称统计
     */
    ONLINE_USER_NAME_LIST;
}
