package cn.allbs.utils.xss.core;

import cn.allbs.utils.xss.XssProperties;
import cn.hutool.core.util.StrUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 功能: xss 处理拦截器
 *
 * @author ChenQi
 * @version 1.0
 * @date 2021/3/31
 */
@RequiredArgsConstructor
public class XssCleanInterceptor implements HandlerInterceptor {

    private final XssProperties xssProperties;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
            throws Exception {
        // 1. 没有开启
        if (!xssProperties.isEnabled()) {
            return true;
        }

        // 2. 非控制器请求直接跳出
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }

        // 3. 只过滤 POST PUT
        if (!StrUtil.equalsAnyIgnoreCase(request.getMethod(), HttpMethod.POST.name(), HttpMethod.PUT.name())) {
            return true;
        }

        // 4. 处理 XssIgnore 注解
        HandlerMethod handlerMethod = (HandlerMethod) handler;
        XssIgnore xssIgnore = AnnotationUtils.findAnnotation(handlerMethod.getMethod(), XssIgnore.class);
        if (xssIgnore == null) {
            XssHolder.setEnable();
        }
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex)
            throws Exception {
        XssHolder.remove();
    }

}
