package cn.allbs.utils.xss.core;

import cn.allbs.utils.xss.utils.XssUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;

/**
 * 功能: xss 处理
 *
 * @author ChenQi
 * @version 1.0
 * @date 2021/3/31
 */
@Slf4j
public class JacksonXssClean extends JsonDeserializer<String> {

    @Override
    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        // XSS filter
        String text = p.getValueAsString();
        if (text == null) {
            return null;
        } else if (XssHolder.isEnabled()) {
            String value = XssUtil.clean(text);
            log.trace("Json property value:{}, current value is:{}.", text, value);
            return value;
        } else {
            return text;
        }
    }

}
