package cn.allbs.utils.xss;

import cn.allbs.utils.xss.core.FormXssClean;
import cn.allbs.utils.xss.core.JacksonXssClean;
import cn.allbs.utils.xss.core.XssCleanInterceptor;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 功能:
 *
 * @author ChenQi
 * @version 1.0
 * @date 2021/3/31
 */
@RequiredArgsConstructor
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(XssProperties.class)
@ConditionalOnProperty(value = "security.xss.enabled", havingValue = "true", matchIfMissing = true)
public class XssAutoConfiguration implements WebMvcConfigurer {

    private final XssProperties xssProperties;

    @Bean
    public FormXssClean formXssClean() {
        return new FormXssClean();
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer xssJacksonCustomizer() {
        return builder -> builder.deserializerByType(String.class, new JacksonXssClean());
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        XssCleanInterceptor interceptor = new XssCleanInterceptor(xssProperties);
        registry.addInterceptor(interceptor).addPathPatterns(xssProperties.getPathPatterns())
                .excludePathPatterns(xssProperties.getExcludePatterns()).order(Ordered.LOWEST_PRECEDENCE);
    }
}
