package cn.allbs.utils.minio;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @Author: chenqi
 * @Describe:
 * @Date: 2020/8/19 11:18
 * @Version 1.0
 */
@Data
@ConfigurationProperties(prefix = "minio")
public class MinioProperties {
    /**
     * minio 地址ip
     */
    private String url;

    /**
     * 是否安全连接, true为https,false为http
     */
    private Boolean secure = false;

    /**
     * 端口
     */
    private Integer port = 9000;

    /**
     * 用户名
     */
    private String accessKey;

    /**
     * 密码
     */
    private String secretKey;

    /**
     * 桶名
     */
    private String bucketName;
}
