package cn.allbs.utils.minio;

import cn.allbs.utils.minio.endpoint.MinioEndpoint;
import cn.allbs.utils.minio.template.MinioTemplate;
import lombok.AllArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author : ChenQi
 * @version 1.0
 * @date : 2020/8/19 11:18
 */
@AllArgsConstructor
@EnableConfigurationProperties({MinioProperties.class})
@Configuration
public class MinioAutoConfiguration {

    private final MinioProperties properties;

    @Bean
    @ConditionalOnMissingBean(MinioTemplate.class)
    @ConditionalOnProperty(name = "minio.url")
    public MinioTemplate template() {
        return new MinioTemplate(properties);
    }


    @Bean
    @ConditionalOnProperty(name = "minio.endpoint.enable", havingValue = "true")
    public MinioEndpoint minioEndpoint(MinioTemplate template) {
        return new MinioEndpoint(template);
    }

}