package cn.allbs.utils.hj212.enums;

import cn.allbs.utils.hj212.translator.CodeMean;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 功能:
 *
 * @author chenQi
 * @version 1.0
 * @Date: 2020/8/23 9:30
 */
@Getter
@AllArgsConstructor
public enum PollutionWater implements CodeMean {

    /**
     * 污水
     */
    w00000("污水", "B01", "升/秒", "立方米", "N5.2"),
    w01001("pH值", "001", "无量纲", "", "N2.2"),
    w01002("色度", "002", "[色]度", "", "N3.2"),
    w01006("溶解性总固体", "--", "毫克/升", "千克", "N4"),
    w01009("溶解氧", "--", "毫克/升", "", "N3.1"),
    w01010("水温", "--", "摄氏度", "", "N3.1"),
    w01012("悬浮物", "003", "毫克/升", "千克", "N4"),
    w01014("电导率", "--", "微西[门子]/厘米", "", "N3.1"),
    w01017("五日生化需氧量", "010", "毫克/升", "千克", "N5.1"),
    w01018("化学需氧量", "011", "毫克/升", "千克", "N5.1"),
    w01019("高锰酸盐指数", "--", "毫克/升", "千克", "N3.1"),
    w01020("总有机碳", "015", "毫克/升", "千克", "N3.1"),
    w02003("粪大肠菌群", "550", "个/升", "", "N9"),
    w02006("细菌总数", "--", "个/升", "", "N9"),
    w03001("总α放射性", "570", "贝可[勒尔]/升", "", "N3.1"),
    w03002("总β放射性", "571", "贝可[勒尔]/升", "", "N3.1"),
    w19001("表面活性剂", "--", "毫克/升", "千克", "N3.2"),
    w19002("阴离子表面活性剂", "520", "毫克/升", "千克", "N3.2"),
    w20012("钡", "039", "毫克/升", "千克", "N3.3"),
    w20023("硼", "037", "毫克/升", "千克", "N3.3"),
    w20038("钴", "040", "毫克/升", "千克", "N3.4"),
    w20061("钼", "038", "毫克/升", "千克", "N3.4"),
    w20089("铊", "041", "纳克/升", "毫克", "N4"),
    w20092("锡", "036", "毫克/升", "千克", "N3.1"),
    w20111("总汞", "020", "微克/升", "克", "N3.2"),
    w20113("烷基汞", "021", "纳克/升", "毫克", "N4"),
    w20115("总镉", "022", "微克/升", "克", "N3.1"),
    w20116("总铬", "023", "毫克/升", "千克", "N3.3"),
    w20117("六价铬", "024", "微克/升", "克", "N2.3"),
    w20119("总砷", "026", "微克/升", "克", "N2.3"),
    w20120("总铅", "027", "微克/升", "克", "N4"),
    w20121("总镍", "028", "毫克/升", "千克", "N3.2"),
    w20122("总铜", "029", "毫克/升", "千克", "N3.2"),
    w20123("总锌", "030", "毫克/升", "千克", "N3.3"),
    w20124("总锰", "031", "毫克/升", "千克", "N3.3"),
    w20125("总铁", "032", "毫克/升", "千克", "N3.3"),
    w20126("总银", "033", "毫克/升", "千克", "N3.3"),
    w20127("总铍", "034", "微克/升", "克", "N3.3"),
    w20128("总硒", "035", "微克/升", "克", "N4.2"),
    w20138("铜", "--", "毫克/升", "千克", "N3.3"),
    w20139("锌", "--", "毫克/升", "千克", "N3.3"),
    w20140("硒", "--", "毫克/升", "千克", "N3.3"),
    w20141("砷", "--", "毫克/升", "千克", "N3.3"),
    w20142("汞", "--", "微克/升", "克", "N3.3"),
    w20143("镉", "--", "微克/升", "克", "N3.3"),
    w20144("铅", "--", "毫克/升", "千克", "N3.3"),
    w21001("总氮", "065", "毫克/升", "千克", "N4.2"),
    w21003("氨氮", "060", "毫克/升", "千克", "N4.2"),
    w21004("凯氏氮", "062", "毫克/升", "千克", "N3.1"),
    w21006("亚硝酸盐", "063", "毫克/升", "千克", "N2.3"),
    w21007("硝酸盐", "064", "毫克/升", "千克", "N2.3"),
    w21011("总磷", "101", "毫克/升", "千克", "N3.2"),
    w21016("氰化物", "070", "毫克/升", "千克", "N3.3"),
    w21017("氟化物", "072", "毫克/升", "千克", "N4.2"),
    w21019("硫化物", "071", "毫克/升", "千克", "N3.3"),
    w21022("氯化物", "090", "毫克/升", "千克", "N3.1"),
    w21038("硫酸盐", "--", "毫克/升", "千克", "N6"),
    w22001("石油类", "080", "毫克/升", "千克", "N3.2"),
    w23002("挥发酚", "110", "毫克/升", "千克", "N3.4"),
    w25043("苯并[α]芘", "540", "微克/升", "克", "N3.1"),
    w33001("六六六", "350", "纳克/升", "毫克", "N4"),
    w33007("滴滴涕", "351", "纳克/升", "毫克", "N4"),
    w99001("有机氮", "061", "毫克/升", "千克", "N3.1");


    private String code;
    private String meaning;
    private String oldCode;
    private String chromaUnit;
    private String amountUnit;
    private String type;

    PollutionWater(String meaning, String chromaUnit, String amountUnit, String type) {
        this.code = name();
        this.meaning = meaning;
        this.oldCode = "--";
        this.chromaUnit = chromaUnit;
        this.amountUnit = amountUnit;
        this.type = type;
    }

    PollutionWater(String meaning, String oldCode, String chromaUnit, String amountUnit, String type) {
        this.code = name();
        this.meaning = meaning;
        this.oldCode = oldCode;
        this.chromaUnit = chromaUnit;
        this.amountUnit = amountUnit;
        this.type = type;
    }

    @Override
    public String code() {
        return oldCode;
    }

    @Override
    public String mean() {
        return code;
    }
}
