package cn.allbs.utils.hj212.enums;

import cn.allbs.utils.hj212.translator.CodeMean;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 功能: 执行结果定义
 *
 * @author chenQi
 * @version 1.0
 * @date 2020/8/23 9:40
 */
@Getter
@AllArgsConstructor
public enum ExecutionResult implements CodeMean {

    /**
     * 执行成功
     */
    _1("执行成功"),
    _2("执行失败，但不知道原因"),
    _3("命令请求条件错误"),
    _4("通讯超时"),
    _5("系统繁忙不能执行"),
    _6("系统故障"),
    _100("没有数据");

    private String code;
    private String meaning;

    ExecutionResult(String meaning) {
        this.code = name().substring(1);
        this.meaning = meaning;
    }

    @Override
    public String code() {
        return code;
    }

    @Override
    public String mean() {
        return meaning;
    }
}
