package cn.allbs.utils.hj212.enums;

import cn.allbs.utils.hj212.translator.CodeMean;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 功能: 数据标记枚举
 *
 * @author chenQi
 * @version 1.0
 * @date 2020/8/23 9:39
 */
@Getter
@AllArgsConstructor
public enum DataFlag implements CodeMean {

    /**
     * 状态设置
     */
    N("在线监控（监测）仪器仪表工作正常"),
    F("在线监控（监测）仪器仪表停运"),
    M("在线监控（监测）仪器仪表处于维护期间产生的数据"),
    S("手工输入的设定值"),
    D("在线监控（监测）仪器仪表故障"),
    C("在线监控（监测）仪器仪表处于校准状态"),
    T("在线监控（监测）仪器仪表采样数值超过测量上限"),
    B("在线监控（监测）仪器仪表与数采仪通讯异常");

    private String code;
    private String meaning;

    DataFlag(String meaning) {
        this.code = name();
        this.meaning = meaning;
    }

    @Override
    public String code() {
        return code;
    }

    @Override
    public String mean() {
        return meaning;
    }
}
