package cn.allbs.utils.common.util;

import cn.allbs.utils.common.enums.ErrorCodeEnum;
import cn.allbs.utils.common.enums.ResponseEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Author: chenQi
 * @Describe:
 * @Date: 2020/8/6 10:02
 * @Version 1.0
 */
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@ApiModel(value = "响应信息主体")
public class R<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    @Getter
    @Setter
    @ApiModelProperty(value = "返回标识：成功-200，失败-201, 异常-自定义")
    private int code;

    @Getter
    @Setter
    @ApiModelProperty(value = "返回信息")
    private String msg;

    @Getter
    @Setter
    @ApiModelProperty(value = "数据")
    private T data;

    public static <T> R<T> ok() {
        return restResult(null, ResponseEnum.SUCCESS_RESPONSE.getCode(), null);
    }

    public static <T> R<T> ok(T data) {
        return restResult(data, ResponseEnum.SUCCESS_RESPONSE.getCode(), null);
    }

    public static <T> R<T> ok(T data, String msg) {
        return restResult(data, ResponseEnum.SUCCESS_RESPONSE.getCode(), msg);
    }

    public static <T> R<T> failed() {
        return restResult(null, ResponseEnum.FAILED_RESPONSE.getCode(), null);
    }

    public static <T> R<T> failed(String msg) {
        return restResult(null, ResponseEnum.FAILED_RESPONSE.getCode(), msg);
    }

    public static <T> R<T> failed(T data) {
        return restResult(data, ResponseEnum.FAILED_RESPONSE.getCode(), null);
    }

    public static <T> R<T> failed(T data, String msg) {
        return restResult(data, ResponseEnum.FAILED_RESPONSE.getCode(), msg);
    }

    public static <T> R<T> exception(ErrorCodeEnum errorCodeEnum) {
        return restResult(null, errorCodeEnum.getCode(), errorCodeEnum.getErrorMsg());
    }

    public static <T> R<T> exception(ErrorCodeEnum errorCodeEnum, String uuCode) {
        return restResult(null, errorCodeEnum.getCode(), errorCodeEnum.getErrorMsg() + ",错误标识码:[" + uuCode + "]");
    }

    public static <T> R<T> exception(int code, String msg) {
        return restResult(null, code, msg);
    }

    private static <T> R<T> restResult(T data, int code, String msg) {
        R<T> apiResult = new R<>();
        apiResult.setCode(code);
        apiResult.setData(data);
        apiResult.setMsg(msg);
        return apiResult;
    }

}
