/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.websocket;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/websocket/{userId}")
@Component
@ConditionalOnProperty(name={"allbs.websocket-active"}, havingValue="true")
public class WebSocketServer {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServer.class);
    private static int onlineCount = 0;
    private static ConcurrentHashMap<String, WebSocketServer> webSocketMap = new ConcurrentHashMap();
    private Session session;
    private String userId = "";

    @OnOpen
    public void onOpen(Session session, @PathParam(value="userId") String userId) {
        this.session = session;
        this.userId = userId;
        if (webSocketMap.containsKey(userId)) {
            webSocketMap.remove(userId);
            webSocketMap.put(userId, this);
        } else {
            webSocketMap.put(userId, this);
            WebSocketServer.addOnlineCount();
        }
        log.info("\u7528\u6237\u8fde\u63a5:" + userId + ",\u5f53\u524d\u5728\u7ebf\u4eba\u6570\u4e3a:" + WebSocketServer.getOnlineCount());
        try {
            this.sendMessage("\u8fde\u63a5\u6210\u529f");
        }
        catch (IOException e) {
            log.error("\u7528\u6237:" + userId + ",\u7f51\u7edc\u5f02\u5e38!!!!!!");
        }
    }

    @OnClose
    public void onClose() {
        if (webSocketMap.containsKey(this.userId)) {
            webSocketMap.remove(this.userId);
            WebSocketServer.subOnlineCount();
        }
        log.info("\u7528\u6237\u9000\u51fa:" + this.userId + ",\u5f53\u524d\u5728\u7ebf\u4eba\u6570\u4e3a:" + WebSocketServer.getOnlineCount());
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        log.info("\u7528\u6237\u6d88\u606f:" + this.userId + ",\u62a5\u6587:" + message);
        if (StringUtils.isNotBlank((String)message)) {
            try {
                JSONObject jsonObject = JSONUtil.parseObj((String)message);
                jsonObject.put("fromUserId", (Object)this.userId);
                String toUserId = jsonObject.getStr((Object)"toUserId");
                if (StringUtils.isNotBlank((String)toUserId) && webSocketMap.containsKey(toUserId)) {
                    webSocketMap.get(toUserId).sendMessage(jsonObject.toString());
                } else {
                    log.error("\u8bf7\u6c42\u7684userId:" + toUserId + "\u4e0d\u5728\u8be5\u670d\u52a1\u5668\u4e0a");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        log.error("\u7528\u6237\u9519\u8bef:" + this.userId + ",\u539f\u56e0:" + error.getMessage());
        error.printStackTrace();
    }

    public void sendMessage(String message) throws IOException {
        this.session.getBasicRemote().sendText(message);
    }

    public static void sendInfo(String message, @PathParam(value="userId") String userId) throws IOException {
        log.info("\u53d1\u9001\u6d88\u606f\u5230:" + userId + "\uff0c\u62a5\u6587:" + message);
        if (StringUtils.isNotBlank((String)userId) && webSocketMap.containsKey(userId)) {
            webSocketMap.get(userId).sendMessage(message);
        } else {
            log.error("\u7528\u6237" + userId + ",\u4e0d\u5728\u7ebf\uff01");
        }
    }

    public static void sendObject(Object o, String dataType, @PathParam(value="userId") String userId) throws IOException {
        log.info("\u53d1\u9001\u6d88\u606f\u5230:" + userId + "\uff0c\u6570\u636e\u7c7b\u578b:" + dataType);
        if (StringUtils.isNotBlank((String)userId) && webSocketMap.containsKey(userId)) {
            webSocketMap.get(userId).sendMessage(new ObjectMapper().writeValueAsString(o));
        } else {
            log.error("\u7528\u6237" + userId + ",\u4e0d\u5728\u7ebf\uff01");
        }
    }

    public static synchronized int getOnlineCount() {
        return onlineCount;
    }

    public static synchronized void addOnlineCount() {
        ++onlineCount;
    }

    public static synchronized void subOnlineCount() {
        --onlineCount;
    }
}

