/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.sms.huawei;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiSmsTemplate {
    private static final Logger log = LoggerFactory.getLogger(HuaweiSmsTemplate.class);
    private static final String WSSE_HEADER_FORMAT = "UsernameToken Username=\"%s\",PasswordDigest=\"%s\",Nonce=\"%s\",Created=\"%s\"";
    private static final String AUTH_HEADER_VALUE = "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"";
    public static final String SMS_CODE = "code";
    public static final String SMS_OK = "000000";
    private String url;
    private String appKey;
    private String appSecret;
    private String sender;
    private String signature;

    public Boolean sendSms(String templateId, String receivers, String[] params) {
        String statusCallBack;
        Boolean sendFlag = false;
        Gson gson = new Gson();
        String templateParas = gson.toJson((Object)params);
        String body = HuaweiSmsTemplate.buildRequestBody(this.sender, receivers, templateId, templateParas, statusCallBack = "", this.signature);
        if (null == body || body.isEmpty()) {
            log.error("[allbs-utils]:body is null.");
            return false;
        }
        String wsseHeader = HuaweiSmsTemplate.buildWsseHeader(this.appKey, this.appSecret);
        if (null == wsseHeader || wsseHeader.isEmpty()) {
            log.error("[allbs-utils]:wsse header is null.");
            return false;
        }
        CloseableHttpClient client = null;
        try {
            client = HttpClients.custom().setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build()).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        CloseableHttpResponse response = null;
        try {
            response = client.execute(RequestBuilder.create((String)"POST").setUri(this.url).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", AUTH_HEADER_VALUE).addHeader("X-WSSE", wsseHeader).setEntity((HttpEntity)new StringEntity(body)).build());
            log.info("[allbs-utils]: response is" + response.toString());
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (entity != null) {
                Map resultMap = (Map)gson.fromJson(result, Map.class);
                log.info("[allbs-utils]:the message is to be sent " + resultMap);
                if (resultMap.get(SMS_CODE).equals(SMS_OK)) {
                    log.info("[allbs-utils]:\u77ed\u4fe1\u53d1\u9001\u6210\u529f,message content is" + result);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("[allbs-utils]:\u77ed\u4fe1API\u8c03\u7528\u5931\u8d25\uff01");
        }
        return true;
    }

    static String buildRequestBody(String sender, String receiver, String templateId, String templateParas, String statusCallbackUrl, String signature) {
        if (null == sender || null == receiver || null == templateId || sender.isEmpty() || receiver.isEmpty() || templateId.isEmpty()) {
            log.error("[allbs-utils]:buildRequestBody sender, receiver or templateId is null.");
            return null;
        }
        ArrayList<BasicNameValuePair> keyValues = new ArrayList<BasicNameValuePair>();
        keyValues.add(new BasicNameValuePair("from", sender));
        keyValues.add(new BasicNameValuePair("to", receiver));
        keyValues.add(new BasicNameValuePair("templateId", templateId));
        if (null != templateParas && !templateParas.isEmpty()) {
            keyValues.add(new BasicNameValuePair("templateParas", templateParas));
        }
        if (null != statusCallbackUrl && !statusCallbackUrl.isEmpty()) {
            keyValues.add(new BasicNameValuePair("statusCallback", statusCallbackUrl));
        }
        if (null != signature && !signature.isEmpty()) {
            keyValues.add(new BasicNameValuePair("signature", signature));
        }
        return URLEncodedUtils.format(keyValues, (Charset)Charset.forName("UTF-8"));
    }

    static String buildWsseHeader(String appKey, String appSecret) {
        if (null == appKey || null == appSecret || appKey.isEmpty() || appSecret.isEmpty()) {
            log.error("[allbs-utils]:appKey or appSecret is null in method buildWsseHeader");
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String time = sdf.format(new Date());
        String nonce = UUID.randomUUID().toString().replace("-", "");
        byte[] passwordDigest = DigestUtils.sha256((String)(nonce + time + appSecret));
        String hexDigest = Hex.encodeHexString((byte[])passwordDigest);
        String passwordDigestBase64Str = Base64.getEncoder().encodeToString(hexDigest.getBytes());
        return String.format(WSSE_HEADER_FORMAT, appKey, passwordDigestBase64Str, nonce, time);
    }

    public HuaweiSmsTemplate(String url, String appKey, String appSecret, String sender, String signature) {
        this.url = url;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.sender = sender;
        this.signature = signature;
    }
}

