/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.logging.listener;

import cn.allbs.utils.logging.config.LoggingProperties;
import cn.allbs.utils.logging.utils.LoggingUtil;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;

public class LoggingStartedEventListener {
    private final LoggingProperties properties;

    @Async
    @Order
    @EventListener(value={WebServerInitializedEvent.class})
    public void afterStart() {
        LoggingProperties.Console console = this.properties.getConsole();
        if (console.isCloseAfterStart()) {
            LoggingUtil.detachAppender("CONSOLE");
        }
    }

    public LoggingStartedEventListener(LoggingProperties properties) {
        this.properties = properties;
    }
}

