/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.logging.append;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import cn.allbs.utils.common.util.JsonUtil;
import cn.allbs.utils.logging.append.ILoggingAppender;
import cn.allbs.utils.logging.config.LoggingProperties;
import cn.allbs.utils.logging.utils.LogStashUtil;
import cn.allbs.utils.logging.utils.LoggingUtil;
import java.util.HashMap;
import net.logstash.logback.composite.JsonProviders;
import net.logstash.logback.encoder.LoggingEventCompositeJsonEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class LoggingJsonFileAppender
implements ILoggingAppender {
    private static final Logger log = LoggerFactory.getLogger(LoggingJsonFileAppender.class);
    private final LoggingProperties properties;
    private final String logAllFile;
    private final String customFieldsJson;

    public LoggingJsonFileAppender(Environment environment, LoggingProperties properties) {
        this.properties = properties;
        String appName = environment.getRequiredProperty("spring.application.name");
        String profile = environment.getRequiredProperty("spring.profiles.active");
        String fileLogPattern = environment.resolvePlaceholders("${FILE_LOG_PATTERN:%d{${LOG_DATEFORMAT_PATTERN:yyyy-MM-dd HH:mm:ss.SSS}} ${LOG_LEVEL_PATTERN:%5p} ${PID:} --- [%t] %-40.40logger{39} : %m%n${LOG_EXCEPTION_CONVERSION_WORD:%wEx}}");
        System.setProperty("FILE_LOG_PATTERN", fileLogPattern);
        String logDir = environment.getProperty("logging.file.path", "logs");
        this.logAllFile = logDir + '/' + appName + '/' + "all.log";
        HashMap<String, String> customFields = new HashMap<String, String>(4);
        customFields.put("appName", appName);
        customFields.put("profile", profile);
        this.customFieldsJson = JsonUtil.toJson(customFields);
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.start(context);
    }

    @Override
    public void start(LoggerContext context) {
        log.info("JsonFile logging start.");
        this.reload(context);
    }

    @Override
    public void reset(LoggerContext context) {
        log.info("JsonFile logging start.");
        this.reload(context);
    }

    private void reload(LoggerContext context) {
        LoggingProperties.Files files = this.properties.getFiles();
        if (files.isEnabled() && files.isUseJsonFormat()) {
            LoggingJsonFileAppender.addAllFileAppender(context, this.logAllFile, this.customFieldsJson);
        }
    }

    private static void addAllFileAppender(LoggerContext context, String logFile, String customFields) {
        RollingFileAppender allFileAppender = new RollingFileAppender();
        allFileAppender.setContext((Context)context);
        allFileAppender.setEncoder((Encoder)LoggingJsonFileAppender.compositeJsonEncoder(context, customFields));
        allFileAppender.setName("FILE");
        allFileAppender.setFile(logFile);
        allFileAppender.setRollingPolicy(LoggingUtil.rollingPolicy(context, allFileAppender, logFile));
        allFileAppender.start();
        context.getLogger("ROOT").detachAppender("FILE");
        context.getLogger("ROOT").addAppender((Appender)allFileAppender);
    }

    private static LoggingEventCompositeJsonEncoder compositeJsonEncoder(LoggerContext context, String customFields) {
        LoggingEventCompositeJsonEncoder compositeJsonEncoder = new LoggingEventCompositeJsonEncoder();
        compositeJsonEncoder.setContext((Context)context);
        compositeJsonEncoder.setProviders((JsonProviders)LogStashUtil.jsonProviders(context, customFields));
        compositeJsonEncoder.start();
        return compositeJsonEncoder;
    }
}

