/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.logging.append;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.rolling.RollingFileAppender;
import cn.allbs.utils.common.util.SystemUtil;
import cn.allbs.utils.logging.append.ILoggingAppender;
import cn.allbs.utils.logging.config.LoggingProperties;
import cn.allbs.utils.logging.utils.LoggingUtil;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class LoggingFileAppender
implements ILoggingAppender {
    private static final Logger log = LoggerFactory.getLogger(LoggingFileAppender.class);
    private final LoggingProperties properties;
    private final String logAllFile;
    private final String logErrorFile;

    public LoggingFileAppender(Environment environment, LoggingProperties properties) {
        this.properties = properties;
        String appName = environment.getRequiredProperty("spring.application.name");
        String fileLogPattern = environment.resolvePlaceholders("${FILE_LOG_PATTERN:%d{${LOG_DATEFORMAT_PATTERN:yyyy-MM-dd HH:mm:ss.SSS}} ${LOG_LEVEL_PATTERN:%5p} ${PID:} --- [%t] %-40.40logger{39} : %m%n${LOG_EXCEPTION_CONVERSION_WORD:%wEx}}");
        System.setProperty("FILE_LOG_PATTERN", fileLogPattern);
        String logDir = environment.getProperty("logging.file.path", "logs");
        this.logAllFile = logDir + '/' + appName + '/' + "all.log";
        this.logErrorFile = logDir + '/' + appName + '/' + "error.log";
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.start(context);
    }

    @Override
    public void start(LoggerContext context) {
        log.info("File logging start.");
        this.reload(context);
    }

    @Override
    public void reset(LoggerContext context) {
        log.info("File logging reset.");
        this.reload(context);
    }

    private void reload(LoggerContext context) {
        LoggingProperties.Files files = this.properties.getFiles();
        if (files.isEnabled() && !files.isUseJsonFormat()) {
            LoggingFileAppender.addAllFileAppender(context, this.logAllFile);
            LoggingFileAppender.addErrorFileAppender(context, this.logErrorFile);
        }
    }

    private static void addAllFileAppender(LoggerContext context, String logFile) {
        RollingFileAppender allFileAppender = new RollingFileAppender();
        allFileAppender.setContext((Context)context);
        allFileAppender.setEncoder(LoggingFileAppender.patternLayoutEncoder(context));
        allFileAppender.setName("FILE");
        allFileAppender.setFile(logFile);
        allFileAppender.setRollingPolicy(LoggingUtil.rollingPolicy(context, allFileAppender, logFile));
        allFileAppender.start();
        context.getLogger("ROOT").detachAppender("FILE");
        context.getLogger("ROOT").addAppender((Appender)allFileAppender);
    }

    private static void addErrorFileAppender(LoggerContext context, String logErrorFile) {
        RollingFileAppender errorFileAppender = new RollingFileAppender();
        errorFileAppender.setContext((Context)context);
        errorFileAppender.addFilter((Filter)LoggingFileAppender.errorLevelFilter(context));
        errorFileAppender.setEncoder(LoggingFileAppender.patternLayoutEncoder(context));
        errorFileAppender.setName("FILE_ERROR");
        errorFileAppender.setFile(logErrorFile);
        errorFileAppender.setRollingPolicy(LoggingUtil.rollingPolicy(context, errorFileAppender, logErrorFile));
        errorFileAppender.start();
        context.getLogger("ROOT").detachAppender("FILE_ERROR");
        context.getLogger("ROOT").addAppender((Appender)errorFileAppender);
    }

    private static Encoder<ILoggingEvent> patternLayoutEncoder(LoggerContext context) {
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)context);
        encoder.setPattern(SystemUtil.getProp("FILE_LOG_PATTERN"));
        String charsetName = SystemUtil.getProp("FILE_LOG_CHARSET", "default");
        encoder.setCharset(Charset.forName(charsetName));
        encoder.start();
        return encoder;
    }

    private static ThresholdFilter errorLevelFilter(LoggerContext context) {
        ThresholdFilter filter = new ThresholdFilter();
        filter.setContext((Context)context);
        filter.setLevel(Level.ERROR.levelStr);
        filter.start();
        return filter;
    }
}

