/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.hj212.deser;

import cn.allbs.utils.hj212.config.SegmentParser;
import cn.allbs.utils.hj212.core.Configurator;
import cn.allbs.utils.hj212.core.Configured;
import cn.allbs.utils.hj212.deser.SegmentDeserializer;
import cn.allbs.utils.hj212.deser.T212Deserializer;
import cn.allbs.utils.hj212.enums.HjDataFlag;
import cn.allbs.utils.hj212.exception.SegmentFormatException;
import cn.allbs.utils.hj212.exception.T212FormatException;
import cn.allbs.utils.hj212.feature.VerifyFeature;
import cn.allbs.utils.hj212.format.T212Parser;
import cn.allbs.utils.hj212.format.VerifyUtil;
import cn.allbs.utils.hj212.model.verify.DataElement;
import cn.allbs.utils.hj212.model.verify.PacketElement;
import cn.allbs.utils.hj212.model.verify.T212CpDataLevelMap;
import cn.allbs.utils.hj212.model.verify.T212Map;
import cn.allbs.utils.hj212.model.verify.groups.ModeGroup;
import cn.allbs.utils.hj212.model.verify.groups.T212MapLevelGroup;
import cn.allbs.utils.hj212.model.verify.groups.VersionGroup;
import cn.allbs.utils.hj212.validator.clazz.FieldValidator;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.validation.Validator;
import javax.validation.groups.Default;

public class CpDataLevelMapDeserializer
implements T212Deserializer<Map<String, Object>>,
Configured<CpDataLevelMapDeserializer> {
    private int verifyFeature;
    private Configurator<SegmentParser> segmentParserConfigurator;
    private SegmentDeserializer<Map<String, Object>> segmentDeserializer;
    private Validator validator;

    @Override
    public void configured(Configurator<CpDataLevelMapDeserializer> configurator) {
        configurator.config(this);
    }

    @Override
    public Map<String, Object> deserialize(T212Parser parser) throws IOException, T212FormatException {
        parser.readHeader();
        int len = parser.readInt32(10);
        if (len == -1) {
            T212FormatException.length_not_range(PacketElement.DATA_LEN, len, 4, 4);
        }
        if (VerifyFeature.DATA_LEN_RANGE.enabledIn(this.verifyFeature)) {
            VerifyUtil.verifyRange(len, 0, 1024, PacketElement.DATA_LEN);
        }
        char[] data = parser.readData(len);
        int crc = parser.readInt32(16);
        if (VerifyFeature.DATA_CRC.enabledIn(this.verifyFeature) && (crc == -1 || T212Parser.crc16Checkout(data, len) != crc)) {
            T212FormatException.crc_verification_failed(PacketElement.DATA, data, crc);
        }
        return this.deserialize(data);
    }

    public Map<String, Object> deserialize(char[] data) throws IOException, T212FormatException {
        PushbackReader reader = new PushbackReader(new CharArrayReader(data));
        SegmentParser parser = new SegmentParser(reader);
        parser.configured(this.segmentParserConfigurator);
        Map<String, Object> result = null;
        try {
            result = this.segmentDeserializer.deserialize(parser);
        }
        catch (SegmentFormatException e) {
            T212FormatException.segment_exception(e);
        }
        if (VerifyFeature.USE_VERIFICATION.enabledIn(this.verifyFeature)) {
            this.verifyByType(result);
        }
        return result;
    }

    private void verifyByType(Map<String, Object> result) throws T212FormatException {
        T212CpDataLevelMap t212Map = T212Map.createCpDataLevel(result);
        T212CpDataLevelMap.Cp cp = t212Map.getCp();
        ArrayList<Class> groups = new ArrayList<Class>();
        groups.add(Default.class);
        int flag = 0;
        if (result.containsKey(DataElement.Flag.name())) {
            String f = (String)result.get(DataElement.Flag.name());
            flag = Integer.valueOf(f);
        }
        if (HjDataFlag.V0.isMarked(flag)) {
            groups.add(VersionGroup.V2017.class);
        } else {
            groups.add(VersionGroup.V2005.class);
        }
        if (HjDataFlag.D.isMarked(flag)) {
            groups.add(ModeGroup.UseSubPacket.class);
        }
        Set constraintViolationSet = this.validator.validate((Object)t212Map, groups.toArray(new Class[0]));
        Set constraintViolationSet2 = this.validator.validate((Object)cp, groups.toArray(new Class[0]));
        constraintViolationSet.addAll(constraintViolationSet2);
        if (!constraintViolationSet.isEmpty() && VerifyFeature.THROW_ERROR_VERIFICATION_FAILED.enabledIn(this.verifyFeature)) {
            FieldValidator.create_format_exception(constraintViolationSet, result);
        }
    }

    @Deprecated
    private void verifyByVersion(Map<String, Object> result) throws T212FormatException {
        Set constraintViolationSet;
        ArrayList<Class<ModeGroup.UseSubPacket>> groups = new ArrayList<Class<ModeGroup.UseSubPacket>>();
        groups.add(Default.class);
        groups.add(T212MapLevelGroup.DataLevel.class);
        int flag = 0;
        if (result.containsKey(DataElement.Flag.name())) {
            String f = (String)result.get(DataElement.Flag.name());
            flag = Integer.valueOf(f);
        }
        T212Map<String, Object> t212Map = HjDataFlag.V0.isMarked(flag) ? T212Map.create2017(result) : T212Map.create2005(result);
        if (HjDataFlag.D.isMarked(flag)) {
            groups.add(ModeGroup.UseSubPacket.class);
        }
        if (!(constraintViolationSet = this.validator.validate(t212Map, groups.toArray(new Class[0]))).isEmpty()) {
            FieldValidator.create_format_exception(constraintViolationSet, result);
        }
    }

    @Deprecated
    private void verify(Map<String, Object> result) throws T212FormatException {
        if (!VerifyFeature.ALLOW_MISSING_FIELD.enabledIn(this.verifyFeature)) {
            Optional<DataElement> missing;
            String f;
            int flag;
            Stream<DataElement> stream = Stream.of(DataElement.values()).filter(DataElement::isRequired);
            if (result.containsKey(DataElement.Flag.name()) && HjDataFlag.D.isMarked(flag = Integer.valueOf(f = (String)result.get(DataElement.Flag.name())).intValue())) {
                stream = Stream.concat(stream, Stream.of(DataElement.PNO, DataElement.PNUM));
            }
            if ((missing = stream.filter(e -> !result.containsKey(e.name())).findFirst()).isPresent()) {
                T212FormatException.field_is_missing(PacketElement.DATA, missing.get().name());
            }
        }
        if (result.containsKey(DataElement.CP.name())) {
            Map cp = (Map)result.get(DataElement.CP.name());
            if (!VerifyFeature.ALLOW_MISSING_FIELD.enabledIn(this.verifyFeature)) {
                Optional<DataElement> missing;
                String f;
                int flag;
                Stream<DataElement> stream = Stream.of(DataElement.values()).filter(DataElement::isRequired);
                if (result.containsKey(DataElement.Flag.name()) && HjDataFlag.D.isMarked(flag = Integer.valueOf(f = (String)result.get(DataElement.Flag.name())).intValue())) {
                    stream = Stream.concat(stream, Stream.of(DataElement.PNO, DataElement.PNUM));
                }
                if ((missing = stream.filter(e -> !result.containsKey(e.name())).findFirst()).isPresent()) {
                    T212FormatException.field_is_missing(PacketElement.DATA, missing.get().name());
                }
            }
        }
    }

    public void setVerifyFeature(int verifyFeature) {
        this.verifyFeature = verifyFeature;
    }

    public void setSegmentParserConfigurator(Configurator<SegmentParser> segmentParserConfigurator) {
        this.segmentParserConfigurator = segmentParserConfigurator;
    }

    public void setSegmentDeserializer(SegmentDeserializer<Map<String, Object>> segmentDeserializer) {
        this.segmentDeserializer = segmentDeserializer;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }
}

