/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.common.util;

import cn.hutool.core.convert.Convert;
import java.util.Objects;
import jodd.util.StringUtil;
import org.springframework.lang.Nullable;

public class SystemUtil {
    private static final String OS_NAME_LINUX = "LINUX";
    @Nullable
    public static final String USER_HOME = SystemUtil.getSystemProperty("user.home");
    @Nullable
    public static final String USER_DIR = SystemUtil.getSystemProperty("user.dir");
    @Nullable
    public static final String USER_NAME = SystemUtil.getSystemProperty("user.name");
    @Nullable
    public static final String OS_NAME = SystemUtil.getSystemProperty("os.name");

    @Nullable
    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public static boolean isLinux() {
        return StringUtil.isNotBlank((CharSequence)OS_NAME) && OS_NAME_LINUX.equalsIgnoreCase(OS_NAME);
    }

    public static boolean isLocalDev() {
        return !SystemUtil.isLinux();
    }

    @Nullable
    public static String getProp(String key) {
        return System.getProperty(key);
    }

    public static String getProp(String key, String defValue) {
        return System.getProperty(key, defValue);
    }

    public static int getPropToInt(String key, int defaultValue) {
        return Convert.toInt((Object)SystemUtil.getProp(key), (Integer)defaultValue);
    }

    public static boolean getPropToBool(String key, boolean defaultValue) {
        return Objects.requireNonNull(Convert.toBool((Object)SystemUtil.getProp(key), (Boolean)defaultValue));
    }

    @Nullable
    public static String getPropOrEnv(String key) {
        String value = System.getProperty(key);
        return value == null ? System.getenv(key) : value;
    }
}

