/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.common.util;

import cn.allbs.utils.common.exception.CheckedException;
import cn.allbs.utils.common.util.ClassUtils;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.util.WebUtils;

public final class AllbsWebUtils
extends WebUtils {
    private static final Logger log = LoggerFactory.getLogger(AllbsWebUtils.class);
    private static final String BASIC_ = "Basic ";
    private static final String UNKNOWN = "unknown";

    public static boolean isBody(HandlerMethod handlerMethod) {
        ResponseBody responseBody = ClassUtils.getAnnotation(handlerMethod, ResponseBody.class);
        return responseBody != null;
    }

    public static String getCookieVal(String name) {
        HttpServletRequest request = AllbsWebUtils.getRequest();
        Assert.notNull((Object)request, (String)"request from RequestContextHolder is null");
        return AllbsWebUtils.getCookieVal(request, name);
    }

    public static String getCookieVal(HttpServletRequest request, String name) {
        Cookie cookie = AllbsWebUtils.getCookie((HttpServletRequest)request, (String)name);
        return cookie != null ? cookie.getValue() : null;
    }

    public static void removeCookie(HttpServletResponse response, String key) {
        AllbsWebUtils.setCookie(response, key, null, 0);
    }

    public static void setCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    public static HttpServletRequest getRequest() {
        try {
            RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
            return ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public static HttpServletResponse getResponse() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
    }

    public static void renderJson(HttpServletResponse response, Object result) {
        AllbsWebUtils.renderJson(response, result, "application/json");
    }

    public static void renderJson(HttpServletResponse response, Object result, String contentType) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType(contentType);
        try (PrintWriter out = response.getWriter();){
            out.append(JSONUtil.toJsonStr((Object)result));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String getIP() {
        return AllbsWebUtils.getIP(AllbsWebUtils.getRequest());
    }

    public static String getIP(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"HttpServletRequest is null");
        String ip = request.getHeader("X-Requested-For");
        if (StrUtil.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (StrUtil.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StrUtil.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StrUtil.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StrUtil.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StrUtil.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return StrUtil.isBlank((CharSequence)ip) ? null : ip.split(",")[0];
    }

    public static String getClientId(String header) {
        byte[] decoded;
        if (header == null || !header.startsWith(BASIC_)) {
            throw new CheckedException("\u8bf7\u6c42\u5934\u4e2dclient\u4fe1\u606f\u4e3a\u7a7a");
        }
        byte[] base64Token = header.substring(6).getBytes("UTF-8");
        try {
            decoded = Base64.decode((byte[])base64Token);
        }
        catch (IllegalArgumentException e) {
            throw new CheckedException("Failed to decode basic authentication token");
        }
        String token = new String(decoded, StandardCharsets.UTF_8);
        int delim = token.indexOf(":");
        if (delim == -1) {
            throw new CheckedException("Invalid basic authentication token");
        }
        return token.substring(0, delim);
    }

    private AllbsWebUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

