/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.common.handle;

import cn.allbs.utils.common.enums.ErrorCodeEnum;
import cn.allbs.utils.common.util.R;
import cn.allbs.utils.validate.exception.ParamCheckException;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.server.ServerErrorException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionHandlerResolver {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandlerResolver.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R unKnowExceptionHandler() {
        return R.exception(ErrorCodeEnum.EXCEPTION_RESPONSE);
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R runtimeExceptionHandler(RuntimeException e) {
        return R.exception(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getLocalizedMessage());
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R nullPointerExceptionHandler(Exception e) {
        e.printStackTrace();
        return R.exception(ErrorCodeEnum.NULL_POINTER_EXCEPTION_RESPONSE);
    }

    @ExceptionHandler(value={ClassCastException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R classCastExceptionHandler() {
        return R.exception(ErrorCodeEnum.CAST_EXCEPTION_RESPONSE);
    }

    @ExceptionHandler(value={IOException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R iOExceptionHandler() {
        return R.exception(ErrorCodeEnum.IO_EXCEPTION_RESPONSE);
    }

    @ExceptionHandler(value={NoSuchMethodException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R noSuchMethodExceptionHandler() {
        return R.exception(ErrorCodeEnum.NO_SUCH_METHOD_EXCEPTION_RESPONSE);
    }

    @ExceptionHandler(value={IndexOutOfBoundsException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R indexOutOfBoundsExceptionHandler() {
        return R.exception(ErrorCodeEnum.INDEX_OUT_OF_BOUND_EXCEPTION_RESPONSE);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R requestNotReadable() {
        return R.exception(ErrorCodeEnum.HTTP_MESSAGE_NOT_READABLE_EXCEPTION_RESPONSE);
    }

    @ExceptionHandler(value={TypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R requestTypeMismatch() {
        return R.exception(ErrorCodeEnum.TYPE_MISMATCH_EXCEPTION_RESPONSE);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R requestMissingServletRequest() {
        return R.exception(ErrorCodeEnum.MISSING_SERVLET_REQUEST_PARAMETER_EXCEPTION_RESPONSE);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException e) {
        ArrayList<String> list = new ArrayList<String>();
        if (!e.getBindingResult().getAllErrors().isEmpty()) {
            for (ObjectError error : e.getBindingResult().getAllErrors()) {
                list.add(error.getDefaultMessage().toString());
            }
        }
        log.error("[allbs-utils]:\u65b9\u6cd5\u53c2\u6570\u9519\u8bef\u5f02\u5e38" + list);
        return R.exception(ErrorCodeEnum.METHOD_ARGUMENT_NOT_VALID_EXCEPTION_RESPONSE.getCode(), ((Object)list).toString());
    }

    @ExceptionHandler(value={ParamCheckException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R resolveMyException(ParamCheckException ex) {
        return R.exception(ErrorCodeEnum.METHOD_ARGUMENT_NOT_VALID_EXCEPTION_RESPONSE.getCode(), ex.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public R request405() {
        return R.exception(ErrorCodeEnum.HTTP_REQUEST_METHOD_NOT_SUPPORTED_EXCEPTION_RESPONSE);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public R request406() {
        return R.exception(ErrorCodeEnum.HTTP_MEDIA_TYPE_NOT_ACCEPTABLE_EXCEPTION_RESPONSE);
    }

    @ExceptionHandler(value={ConversionNotSupportedException.class, HttpMessageNotWritableException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R server500() {
        return R.exception(ErrorCodeEnum.CONVERSION_NOT_ACCEPTABLE_EXCEPTION_RESPONSE);
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    public R httpMediaTypeNotSupportedExceptionHandler() {
        return R.exception(ErrorCodeEnum.HTTP_MEDIA_TYPE_NOT_SUPPORTED_EXCEPTION_RESPONSE);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public R notFoundException() {
        return R.exception(ErrorCodeEnum.NO_HANDLER_FOUND_EXCEPTION_RESPONSE);
    }

    @ExceptionHandler(value={ServerErrorException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R serverErrorExceptionHandler(ServerErrorException e) {
        return R.exception(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getLocalizedMessage());
    }
}

