package cn.allbs.utils.sms.huawei;

import lombok.AllArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

/**
 * 功能:
 *
 * @author ChenQi
 * @version 1.0
 * @date 2021/3/10 13:57
 */
@AllArgsConstructor
@EnableConfigurationProperties({HuaweiSmsProperties.class})
@Component
public class HuaweiSmsConfiguration {

    private final HuaweiSmsProperties huaweiSmsProperties;

    @Bean
    @ConditionalOnMissingBean(HuaweiSmsTemplate.class)
    @ConditionalOnProperty(name = "sms.url")
    HuaweiSmsTemplate huaweiSmsTemplate() {
        return new HuaweiSmsTemplate(
                huaweiSmsProperties.getUrl(),
                huaweiSmsProperties.getAppKey(),
                huaweiSmsProperties.getAppSecret(),
                huaweiSmsProperties.getSender(),
                huaweiSmsProperties.getSignature()
        );
    }
}
