package cn.allbs.utils.scheduled;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

/**
 * @author ChenQi
 */
@Configuration
@EnableAsync
@EnableScheduling
public class TaskSchedulingConfig {

    @Bean
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        // 定时任务执行线程池核心线程数
        taskScheduler.setPoolSize(10);
        taskScheduler.setRemoveOnCancelPolicy(true);
        taskScheduler.setThreadNamePrefix("DynamicAllbsSchedulerThreadPool-");
        return taskScheduler;
    }

    @Bean
    @ConditionalOnMissingBean(CronTaskRegistrar.class)
    public CronTaskRegistrar cronTaskRegistrar() {
        return new CronTaskRegistrar(taskScheduler());
    }
}
