package cn.allbs.utils.hj212.model;

import cn.allbs.utils.hj212.model.verify.groups.VersionGroup;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.json.bind.annotation.JsonbProperty;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.Max;
import java.math.BigDecimal;

/**
 * 功能:
 *
 * @author chenQi
 * @version 1.0
 * @date 2020/8/23 10:26
 */
@Data
public class Device {

    @ApiModelProperty(value = "污染治理设施运行状态的实时采样值", name = "RS")
    @Max(value = 5, groups = VersionGroup.V2017.class)
    @JsonProperty("RS")
    @JsonbProperty("RS")
    private int rs;

    @ApiModelProperty(value = "污染治理设施一日内的运行时间", name = "RT")
    @DecimalMax(value = "24", groups = VersionGroup.V2017.class)
    @JsonProperty("RT")
    @JsonbProperty("RT")
    private BigDecimal rt;
}
