package cn.allbs.utils.hj212.enums;

import cn.allbs.utils.hj212.translator.CodeMean;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 功能:
 *
 * @author chenQi
 * @version 1.0
 * @date 2020/8/23 9:41
 */
@Getter
@AllArgsConstructor
public enum GBT16706 implements CodeMean {

    /**
     *
     */
    _21("21", "地表水质量监测"),
    _22("22", "空气质量监测"),
    _23("23", "声环境质量监测"),
    _24("24", "地下水质量监测"),
    _25("25", "土壤质量监测"),
    _26("26", "海水质量监测"),
    _27("27", "挥发性有机物监测"),
    _31("31", "大气环境污染源"),
    _32("32", "地表水体环境污染源"),
    _33("33", "地下水体环境污染源"),
    _34("34", "海洋环境污染源"),
    _35("35", "土壤环境污染源"),
    _36("36", "声环境污染源"),
    _37("37", "振动环境污染源"),
    _38("38", "放射性环境污染源"),
    _39("39", "工地扬尘污染源"),
    _41("41", "电磁环境污染源"),
    _51("51", "烟气排放过程监控"),
    _52("52", "污水排放过程监控"),
    _91("91", "系统交互");


    private String code;
    private String meaning;

    GBT16706(String meaning) {
        this.code = name().substring(1);
        this.meaning = meaning;
    }

    @Override
    public String code() {
        return code;
    }

    @Override
    public String mean() {
        return meaning;
    }
}
