package cn.allbs.utils.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.http.HttpStatus;

/**
 * @Author: chenqi
 * @Describe: 错误码
 * @Date: 2020/8/20 15:59
 * @Version 1.0
 */
@Getter
@AllArgsConstructor
public enum ErrorCodeEnum {

    /**
     * 未知异常
     */
    EXCEPTION_RESPONSE(HttpStatus.INTERNAL_SERVER_ERROR.value(), "未知服务异常，请联系管理员！"),

    NULL_POINTER_EXCEPTION_RESPONSE(HttpStatus.INTERNAL_SERVER_ERROR.value(), "空指针异常！"),

    CAST_EXCEPTION_RESPONSE(HttpStatus.INTERNAL_SERVER_ERROR.value(), "类型转换异常！"),

    IO_EXCEPTION_RESPONSE(HttpStatus.INTERNAL_SERVER_ERROR.value(), "IO异常！"),

    NO_SUCH_METHOD_EXCEPTION_RESPONSE(HttpStatus.INTERNAL_SERVER_ERROR.value(), "未知方法异常！"),

    INDEX_OUT_OF_BOUND_EXCEPTION_RESPONSE(HttpStatus.INTERNAL_SERVER_ERROR.value(), "数组下标越界异常！"),

    HTTP_MESSAGE_NOT_READABLE_EXCEPTION_RESPONSE(HttpStatus.BAD_REQUEST.value(), "前端参数没有序列化或前端参数与接口参数类型不匹配！"),

    TYPE_MISMATCH_EXCEPTION_RESPONSE(HttpStatus.BAD_REQUEST.value(), "参数类型不匹配！"),

    MISSING_SERVLET_REQUEST_PARAMETER_EXCEPTION_RESPONSE(HttpStatus.BAD_REQUEST.value(), "缺少必要参数！"),

    METHOD_ARGUMENT_NOT_VALID_EXCEPTION_RESPONSE(HttpStatus.BAD_REQUEST.value(), "参数验证不通过！"),

    USERNAME_NOT_FOUND_EXCEPTION_RESPONSE(HttpStatus.UNAUTHORIZED.value(), "用户名不存在！"),

    HTTP_REQUEST_METHOD_NOT_SUPPORTED_EXCEPTION_RESPONSE(HttpStatus.METHOD_NOT_ALLOWED.value(), "请求方法不正确！"),

    HTTP_MEDIA_TYPE_NOT_ACCEPTABLE_EXCEPTION_RESPONSE(HttpStatus.NOT_ACCEPTABLE.value(), "不接受该请求！"),

    CONVERSION_NOT_ACCEPTABLE_EXCEPTION_RESPONSE(HttpStatus.NOT_ACCEPTABLE.value(), "不允许转换或消息不可写入！"),

    HTTP_MEDIA_TYPE_NOT_SUPPORTED_EXCEPTION_RESPONSE(HttpStatus.UNSUPPORTED_MEDIA_TYPE.value(), "服务器无法处理请求附带的媒体格式！"),

    NO_HANDLER_FOUND_EXCEPTION_RESPONSE(HttpStatus.NOT_FOUND.value(), "找不到服务！"),

    ACCESS_DENIED_EXCEPTION_RESPONSE(HttpStatus.FORBIDDEN.value(), "没有权限！"),

    USER_OR_PASSWORD_ERROR(HttpStatus.FORBIDDEN.value(), "账号或者密码错误！");

    /**
     * 自定义编码
     */
    private final Integer code;

    /**
     * 自定义异常信息
     */
    private final String errorMsg;
}
