package cn.allbs.utils.cache.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.HashSet;
import java.util.Set;

/**
 * 功能:
 *
 * @author ChenQi
 * @version 1.0
 * @date 2021/3/20 下午4:11
 */
@Data
@ConfigurationProperties(prefix = "spring.cache.multi")
public class CacheConfigProperties {

    private Set<String> cacheNames = new HashSet<>();

    /**
     * 是否存储空值，默认true，防止缓存穿透
     */
    private boolean cacheNullValues = true;

    /**
     * 是否动态根据cacheName创建Cache的实现，默认true
     */
    private boolean dynamic = true;

    /**
     * 缓存key的前缀
     */
    private String cachePrefix;

    /**
     * 二级缓存属性配置
     */
    private RedisConfigProp redis = new RedisConfigProp();

    /**
     * 一级缓存属性配置
     */
    private CaffeineConfigProp caffeine = new CaffeineConfigProp();

    /**
     * 是否使用jackson序列化
     */
    private boolean jacksonUse = true;

}