/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.validate;

import cn.allbs.utils.annotation.ParamVal;
import cn.allbs.utils.common.enums.RegexOption;
import cn.allbs.utils.validate.exception.ParamCheckException;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ParamCheckAspect {
    private static final String LINK_HASH_MAP_TYPE = "java.util.LinkedHashMap";

    @Pointcut(value="@annotation(cn.allbs.utils.annotation.ParamVal)")
    public void paramCheckAspect() {
    }

    @Before(value="paramCheckAspect()")
    public void parameterVerify(JoinPoint point) throws Exception {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        Object[] args = point.getArgs();
    }

    private void validate(ParamVal paramVal, Object fieldObj) throws Exception {
        Pattern pattern;
        String name = paramVal.value();
        String message = StrUtil.format((CharSequence)"\u53c2\u6570{}\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[]{name});
        if (paramVal.required() && fieldObj == null) {
            throw new ParamCheckException(StrUtil.format((CharSequence)"{}\u4e3a\u5fc5\u4f20\u53c2\u6570\uff01", (Object[])new Object[]{name}));
        }
        if (ObjectUtil.isEmpty((Object)fieldObj)) {
            throw new ParamCheckException(message);
        }
        if (!RegexOption.DEFAULT.getRegex().equals(paramVal.regular().getRegex()) && ReUtil.isMatch((Pattern)(pattern = Pattern.compile(paramVal.regular().getRegex())), (CharSequence)String.valueOf(fieldObj))) {
            throw new ParamCheckException(StrUtil.format((CharSequence)"\u53c2\u6570{}\u8bf7\u6c42\u89c4\u5219\u4e0d\u5339\u914d\uff01", (Object[])new Object[]{name}));
        }
    }
}

