/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.swagger;

import cn.allbs.utils.swagger.SwaggerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableConfigurationProperties(value={SwaggerProperties.class})
@EnableSwagger2
public class Swagger2Config {
    private final SwaggerProperties swaggerProperties;

    @Profile(value={"dev", "test"})
    @Bean
    public Docket createRestApi() {
        ApiInfo apiInfo = new ApiInfoBuilder().title(this.swaggerProperties.getTitle()).description(this.swaggerProperties.getDescription()).contact(new Contact(this.swaggerProperties.getName(), this.swaggerProperties.getUrl(), this.swaggerProperties.getEmail())).termsOfServiceUrl(this.swaggerProperties.getTermServiceUrl()).version(this.swaggerProperties.getVersion()).build();
        return new Docket(DocumentationType.SWAGGER_2).host(this.swaggerProperties.getHost()).groupName(this.swaggerProperties.getGroupName()).apiInfo(apiInfo).select().apis(RequestHandlerSelectors.basePackage((String)this.swaggerProperties.getBasePackage())).paths(PathSelectors.any()).build();
    }

    public Swagger2Config(SwaggerProperties swaggerProperties) {
        this.swaggerProperties = swaggerProperties;
    }
}

