/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.scheduled;

import cn.allbs.utils.scheduled.CronTaskRegistrar;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@EnableAsync
@EnableScheduling
public class TaskSchedulingConfig {
    @Bean
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(10);
        taskScheduler.setRemoveOnCancelPolicy(true);
        taskScheduler.setThreadNamePrefix("DynamicAllbsSchedulerThreadPool-");
        return taskScheduler;
    }

    @Bean
    @ConditionalOnMissingBean(value={CronTaskRegistrar.class})
    public CronTaskRegistrar cronTaskRegistrar() {
        return new CronTaskRegistrar(this.taskScheduler());
    }
}

