/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.influxdb;

import cn.allbs.utils.influxdb.InfluxDbProperties;
import cn.allbs.utils.influxdb.InfluxTemplate;
import org.influxdb.BatchOptions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={InfluxDbProperties.class})
public class InfluxDbConfiguration {
    private final InfluxDbProperties influxDbProperties;

    @Bean
    @ConditionalOnMissingBean(value={InfluxTemplate.class})
    public InfluxTemplate influxTemplate() {
        BatchOptions batchOptions = BatchOptions.DEFAULTS;
        InfluxTemplate influxTemplate = new InfluxTemplate(this.influxDbProperties, batchOptions);
        influxTemplate.createRetentionPolicy();
        return influxTemplate;
    }

    public InfluxDbConfiguration(InfluxDbProperties influxDbProperties) {
        this.influxDbProperties = influxDbProperties;
    }
}

