/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.hj212.converter;

import cn.allbs.utils.hj212.converter.Converter;
import cn.allbs.utils.hj212.core.Configurator;
import cn.allbs.utils.hj212.core.Configured;
import cn.allbs.utils.hj212.enums.HjDataFlag;
import cn.allbs.utils.hj212.model.CpData;
import cn.allbs.utils.hj212.model.Device;
import cn.allbs.utils.hj212.model.HjData;
import cn.allbs.utils.hj212.model.LiveSide;
import cn.allbs.utils.hj212.model.Pollution;
import cn.allbs.utils.hj212.model.verify.DataElement;
import cn.allbs.utils.hj212.model.verify.T212Map;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataConverter
implements Converter<T212Map<String, Object>, HjData>,
Configured<DataConverter> {
    private static String SPLIT = "-";
    private static String SB = "SB";
    private static String REGEX_DEVICE = "SB.*-RS$|SB.*-RT$";
    private static String REGEX_LIVE_SIDE = ".*-Info$|.*-SN$";
    private static String REGEX_POLLUTION = ".*-.*";
    private ObjectMapper objectMapper;
    private Predicate<String> predicateDevice = Pattern.compile(REGEX_DEVICE).asPredicate();
    private Predicate<String> predicateLiveSide = Pattern.compile(REGEX_LIVE_SIDE).asPredicate();
    private Predicate<String> predicatePollution = Pattern.compile(REGEX_POLLUTION).asPredicate();

    private Map<String, Map<String, String>> groupBySplitKey(Map<String, String> map, String split) {
        Map<String, Map<String, String>> result = map.entrySet().stream().collect(Collectors.groupingBy(t -> ((String)t.getKey()).split(split)[0], Collectors.toMap(kv -> ((String)kv.getKey()).split(split)[1], Map.Entry::getValue)));
        return result;
    }

    private Map<String, LiveSide> convertLiveSide(Map<String, String> map) {
        return this.groupBySplitKey(map, SPLIT).entrySet().stream().map(kv -> {
            LiveSide liveSide = (LiveSide)this.objectMapper.convertValue(kv.getValue(), LiveSide.class);
            return new AbstractMap.SimpleEntry(kv.getKey(), liveSide);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private Map<String, Device> convertDevice(Map<String, String> map) {
        return this.groupBySplitKey(map, SPLIT).entrySet().stream().map(kv -> {
            Device device = (Device)this.objectMapper.convertValue(kv.getValue(), Device.class);
            return new AbstractMap.SimpleEntry<String, Device>(((String)kv.getKey()).replace(SB, ""), device);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private Map<String, Pollution> convertPollution(Map<String, String> map) {
        return this.groupBySplitKey(map, SPLIT).entrySet().stream().map(kv -> {
            Pollution pollution = (Pollution)this.objectMapper.convertValue(kv.getValue(), Pollution.class);
            return new AbstractMap.SimpleEntry(kv.getKey(), pollution);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private Map<String, String> filter(Map<String, String> map, Predicate<String> predicate) {
        return map.entrySet().stream().filter(kv -> predicate.test((String)kv.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, Object> convertDataLevel(Map<String, String> map) {
        Map<String, String> p;
        String flag;
        Map<String, String> ls;
        HashMap<String, Object> cp = new HashMap<String, Object>();
        Map<String, String> d = this.filter(map, this.predicateDevice);
        if (!d.isEmpty()) {
            Map<String, Device> deviceMap = this.convertDevice(d);
            cp.put(CpData.DEVICE, deviceMap);
            d.keySet().forEach(map::remove);
        }
        if (!(ls = this.filter(map, this.predicateLiveSide)).isEmpty()) {
            Map<String, LiveSide> liveSideMap = this.convertLiveSide(ls);
            cp.put(CpData.LIVESIDE, liveSideMap);
            ls.keySet().forEach(map::remove);
        }
        if ((flag = map.get(DataElement.Flag.name())) != null) {
            List<HjDataFlag> dataFlags = this.convertDataFlag(flag);
            map.remove(DataElement.Flag.name());
            cp.put(HjData.FLAG, dataFlags);
        }
        if (!(p = this.filter(map, this.predicatePollution)).isEmpty()) {
            Map<String, Pollution> pollutionMap = this.convertPollution(p);
            cp.put(CpData.POLLUTION, pollutionMap);
            p.keySet().forEach(map::remove);
        }
        cp.putAll(map);
        return cp;
    }

    private List<HjDataFlag> convertDataFlag(String flag) {
        if (flag != null) {
            int i = Integer.parseInt(flag);
            return Stream.of(HjDataFlag.values()).filter(sf -> sf.isMarked(i)).collect(Collectors.toList());
        }
        return null;
    }

    private HjData convertDataLevel(T212Map<String, Object> map) {
        Map cp;
        String flag = (String)map.get(DataElement.Flag.name());
        if (flag != null) {
            List<HjDataFlag> flagList = this.convertDataFlag(flag);
            map.put(HjData.FLAG, flagList);
        }
        if ((cp = (Map)map.get(DataElement.CP.name())) != null) {
            Map<String, Object> cpMap = this.convertDataLevel(cp);
            map.put(HjData.CP, cpMap);
        }
        return (HjData)this.objectMapper.convertValue(map, HjData.class);
    }

    @Override
    public HjData convert(T212Map<String, Object> map) {
        return this.convertDataLevel(map);
    }

    @Override
    public void configured(Configurator<DataConverter> by) {
        by.config(this);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

