/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.cache.support;

import cn.allbs.utils.cache.listener.CacheMessage;
import cn.allbs.utils.cache.properties.CacheConfigProperties;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.github.benmanes.caffeine.cache.Cache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisCaffeineCache
extends AbstractValueAdaptingCache {
    private static final Logger log = LoggerFactory.getLogger(RedisCaffeineCache.class);
    private final String name;
    private final Cache<Object, Object> caffeineCache;
    private final String cachePrefix;
    private final long defaultExpiration;
    private final Map<String, Long> expires;
    private final String topic;
    private final Map<String, ReentrantLock> keyLockMap = new ConcurrentHashMap<String, ReentrantLock>();
    private final boolean usedCaffeineCache;
    private final boolean usedRedisCache;
    private final RedisTemplate<Object, Object> redisTemplate;

    public RedisCaffeineCache(String name, RedisTemplate<Object, Object> redisTemplate, Cache<Object, Object> caffeineCache, CacheConfigProperties cacheConfigProperties) {
        super(cacheConfigProperties.isCacheNullValues());
        this.name = name;
        this.caffeineCache = caffeineCache;
        this.cachePrefix = cacheConfigProperties.getCachePrefix();
        this.defaultExpiration = cacheConfigProperties.getRedis().getDefaultExpiration();
        this.expires = cacheConfigProperties.getRedis().getExpires();
        this.topic = cacheConfigProperties.getRedis().getTopic();
        this.usedCaffeineCache = cacheConfigProperties.getCaffeine().isUsedCaffeineCache();
        this.usedRedisCache = cacheConfigProperties.getRedis().isUsedRedisCache();
        this.redisTemplate = redisTemplate;
    }

    public Object getNativeCache() {
        return this;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value = this.lookup(key);
        if (value != null) {
            return (T)value;
        }
        ReentrantLock lock = this.keyLockMap.computeIfAbsent(key.toString(), s -> {
            log.trace("create lock for key : {}", s);
            return new ReentrantLock();
        });
        lock.lock();
        try {
            value = this.lookup(key);
            if (value != null) {
                Object object = value;
                return (T)object;
            }
            value = valueLoader.call();
            Object storeValue = this.toStoreValue(value);
            this.put(key, storeValue);
            Object object = value;
            return (T)object;
        }
        catch (Exception e) {
            throw new Cache.ValueRetrievalException(key, valueLoader, e.getCause());
        }
        finally {
            lock.unlock();
        }
    }

    public void put(Object key, Object value) {
        if (!super.isAllowNullValues() && value == null) {
            this.evict(key);
            return;
        }
        if (this.usedRedisCache) {
            long expire = this.getExpire();
            if (expire > 0L) {
                this.redisTemplate.opsForValue().set(this.getKey(key), this.toStoreValue(value), expire, TimeUnit.MILLISECONDS);
            } else {
                this.redisTemplate.opsForValue().set(this.getKey(key), this.toStoreValue(value));
            }
            this.push(new CacheMessage(this.name, key));
        }
        if (this.usedCaffeineCache) {
            this.caffeineCache.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object cacheKey = this.getKey(key);
        Object prevValue = null;
        Object object = key;
        synchronized (object) {
            if (this.usedRedisCache && (prevValue = this.redisTemplate.opsForValue().get(this.getKey(key))) == null) {
                long expire = this.getExpire();
                if (expire > 0L) {
                    this.redisTemplate.opsForValue().set(cacheKey, this.toStoreValue(value), expire, TimeUnit.MILLISECONDS);
                } else {
                    this.redisTemplate.opsForValue().set(cacheKey, this.toStoreValue(value));
                }
                this.push(new CacheMessage(this.name, key));
            }
            if (this.usedCaffeineCache && (prevValue = this.caffeineCache.getIfPresent(key)) == null) {
                this.caffeineCache.put(key, this.toStoreValue(value));
            }
        }
        return this.toValueWrapper(prevValue);
    }

    public void evict(Object key) {
        if (this.usedRedisCache) {
            this.redisTemplate.delete(this.getKey(key));
            this.push(new CacheMessage(this.name, key));
        }
        if (this.usedCaffeineCache) {
            this.caffeineCache.invalidate(key);
        }
    }

    public void clear() {
        if (this.usedRedisCache) {
            Set keys = this.redisTemplate.keys((Object)this.name.concat(":*"));
            if (!CollUtil.isEmpty((Collection)keys)) {
                this.redisTemplate.delete((Collection)keys);
            }
            this.push(new CacheMessage(this.name, null));
        }
        if (this.usedCaffeineCache) {
            this.caffeineCache.invalidateAll();
        }
    }

    protected Object lookup(Object key) {
        Object cacheKey = this.getKey(key);
        Object value = null;
        if (this.usedCaffeineCache && (value = this.caffeineCache.getIfPresent(key)) != null) {
            log.debug("get cache from caffeine, the key is : {}", cacheKey);
            return value;
        }
        if (this.usedRedisCache) {
            this.redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
            value = this.redisTemplate.opsForValue().get(cacheKey);
            if (value != null) {
                log.debug("get cache from redis and put in caffeine, the key is : {}", cacheKey);
                this.caffeineCache.put(key, value);
            }
        }
        return value;
    }

    private Object getKey(Object key) {
        return this.name.concat(":").concat(StrUtil.isEmpty((CharSequence)this.cachePrefix) ? key.toString() : this.cachePrefix.concat(":").concat(key.toString()));
    }

    private long getExpire() {
        Long cacheNameExpire = this.expires.get(this.name);
        return cacheNameExpire == null ? this.defaultExpiration : cacheNameExpire;
    }

    private void push(CacheMessage message) {
        this.redisTemplate.convertAndSend(this.topic, (Object)message);
    }

    public void clearLocal(Object key) {
        log.debug("clear local cache, the key is : {}", key);
        if (key == null) {
            this.caffeineCache.invalidateAll();
        } else {
            this.caffeineCache.invalidate(key);
        }
    }

    public String getName() {
        return this.name;
    }

    public Cache<Object, Object> getCaffeineCache() {
        return this.caffeineCache;
    }
}

