/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.log;

import cn.allbs.utils.annotation.SysLog;
import cn.allbs.utils.common.enums.LogTypeEnum;
import cn.allbs.utils.log.SysLogEvent;
import cn.allbs.utils.log.model.SysLogUtilsEntity;
import cn.hutool.core.util.URLUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.http.HttpUtil;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class SysLogAspect {
    private static final Logger log = LoggerFactory.getLogger(SysLogAspect.class);
    private final ApplicationEventPublisher publisher;

    @Around(value="@annotation(sysLog)")
    public Object around(ProceedingJoinPoint point, SysLog sysLog) {
        Object obj;
        String strClassName = point.getTarget().getClass().getName();
        String strMethodName = point.getSignature().getName();
        log.debug("[\u7c7b\u540d]:{},[\u65b9\u6cd5]:{}", (Object)strClassName, (Object)strMethodName);
        SysLogUtilsEntity logVo = this.getSysLog();
        logVo.setTitle(sysLog.value());
        Long startTime = System.currentTimeMillis();
        try {
            obj = point.proceed();
        }
        catch (Exception e) {
            logVo.setType(LogTypeEnum.ERROR.getType());
            logVo.setException(e.getMessage());
            throw e;
        }
        finally {
            Long endTime = System.currentTimeMillis();
            logVo.setTime(endTime - startTime);
            this.publisher.publishEvent((Object)new SysLogEvent(logVo));
        }
        return obj;
    }

    private SysLogUtilsEntity getSysLog() {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        SysLogUtilsEntity sysLog = new SysLogUtilsEntity();
        sysLog.setType(LogTypeEnum.NORMAL.getType());
        sysLog.setRemoteAddr(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        sysLog.setRequestUri(URLUtil.getPath((String)request.getRequestURI()));
        sysLog.setMethod(request.getMethod());
        sysLog.setUserAgent(request.getHeader("user-agent"));
        sysLog.setParams(HttpUtil.toParams((Map)request.getParameterMap()));
        return sysLog;
    }

    public SysLogAspect(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }
}

