/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.hj212.ser;

import cn.allbs.utils.hj212.config.SegmentGenerator;
import cn.allbs.utils.hj212.core.Configurator;
import cn.allbs.utils.hj212.core.Configured;
import cn.allbs.utils.hj212.exception.SegmentFormatException;
import cn.allbs.utils.hj212.exception.T212FormatException;
import cn.allbs.utils.hj212.feature.VerifyFeature;
import cn.allbs.utils.hj212.format.T212Generator;
import cn.allbs.utils.hj212.format.VerifyUtil;
import cn.allbs.utils.hj212.model.verify.PacketElement;
import cn.allbs.utils.hj212.ser.SegmentSerializer;
import cn.allbs.utils.hj212.ser.T212Serializer;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import javax.validation.Validator;

public class CpDataLevelMapDataSerializer
implements T212Serializer<Map<String, Object>>,
Configured<CpDataLevelMapDataSerializer> {
    private int verifyFeature;
    private Configurator<SegmentGenerator> segmentGeneratorConfigurator;
    private SegmentSerializer<Map<String, Object>> segmentSerializer;
    private Validator validator;

    @Override
    public void configured(Configurator<CpDataLevelMapDataSerializer> configurator) {
        configurator.config(this);
    }

    @Override
    public void serialize(T212Generator generator, Map<String, Object> data) throws IOException, T212FormatException {
        generator.writeHeader();
        char[] segment = this.serialize(data);
        if (VerifyFeature.DATA_LEN_RANGE.enabledIn(this.verifyFeature)) {
            int segmentLen = segment.length;
            VerifyUtil.verifyRange(segmentLen, 0, 1024, PacketElement.DATA_LEN);
        }
        generator.writeDataAndLenAndCrc(segment);
        generator.writeFooter();
    }

    public char[] serialize(Map<String, Object> data) throws IOException, T212FormatException {
        StringWriter writer = new StringWriter();
        SegmentGenerator generator = new SegmentGenerator(writer);
        generator.configured(this.segmentGeneratorConfigurator);
        try {
            this.segmentSerializer.serialize(generator, data);
        }
        catch (SegmentFormatException e) {
            T212FormatException.segment_exception(e);
        }
        return writer.toString().toCharArray();
    }

    public void setVerifyFeature(int verifyFeature) {
        this.verifyFeature = verifyFeature;
    }

    public void setSegmentGeneratorConfigurator(Configurator<SegmentGenerator> segmentGeneratorConfigurator) {
        this.segmentGeneratorConfigurator = segmentGeneratorConfigurator;
    }

    public void setSegmentSerializer(SegmentSerializer<Map<String, Object>> segmentSerializer) {
        this.segmentSerializer = segmentSerializer;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }
}

