/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.excel.aop;

import cn.allbs.utils.annotation.ExportExcel;
import cn.allbs.utils.excel.handle.SheetWriteHandler;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ResponseExcelReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private static final Logger log = LoggerFactory.getLogger(ResponseExcelReturnValueHandler.class);
    private final List<SheetWriteHandler> sheetWriteHandlerList;

    public boolean supportsReturnType(MethodParameter parameter) {
        return parameter.getMethodAnnotation(ExportExcel.class) != null;
    }

    public void handleReturnValue(Object o, MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest nativeWebRequest) throws Exception {
        HttpServletResponse response = (HttpServletResponse)nativeWebRequest.getNativeResponse(HttpServletResponse.class);
        Assert.state((response != null ? 1 : 0) != 0, (String)"No HttpServletResponse");
        ExportExcel responseExcel = (ExportExcel)parameter.getMethodAnnotation(ExportExcel.class);
        Assert.state((responseExcel != null ? 1 : 0) != 0, (String)"No @ResponseExcel");
        mavContainer.setRequestHandled(true);
        this.sheetWriteHandlerList.stream().filter(handler -> handler.support(o)).findFirst().ifPresent(handler -> handler.export(o, response, responseExcel));
    }

    public ResponseExcelReturnValueHandler(List<SheetWriteHandler> sheetWriteHandlerList) {
        this.sheetWriteHandlerList = sheetWriteHandlerList;
    }
}

