/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.common.handle;

import cn.allbs.utils.common.enums.ErrorCodeEnum;
import cn.allbs.utils.common.handle.IgnoreUrlProperties;
import cn.allbs.utils.common.util.R;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

public class ResponseControllerAdvice
implements ResponseBodyAdvice<Object> {
    private final IgnoreUrlProperties ignoreUrlProperties;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> aClass) {
        return !returnType.getGenericParameterType().equals(R.class);
    }

    private boolean ignoring(String uri) {
        for (String string : this.ignoreUrlProperties.getUrls()) {
            if (!uri.contains(string)) continue;
            return true;
        }
        return false;
    }

    public Object beforeBodyWrite(Object data, MethodParameter returnType, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        if (this.ignoring(serverHttpRequest.getURI().toString())) {
            return data;
        }
        if (returnType.getGenericParameterType().equals(String.class)) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return objectMapper.writeValueAsString(R.ok(data));
            }
            catch (JsonProcessingException e) {
                return R.exception(ErrorCodeEnum.EXCEPTION_RESPONSE);
            }
        }
        return R.ok(data);
    }

    public ResponseControllerAdvice(IgnoreUrlProperties ignoreUrlProperties) {
        this.ignoreUrlProperties = ignoreUrlProperties;
    }
}

