/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.minio.template;

import cn.allbs.utils.minio.MinioProperties;
import cn.allbs.utils.minio.model.MinioItem;
import cn.hutool.core.bean.BeanUtil;
import io.minio.MinioClient;
import io.minio.ObjectStat;
import io.minio.Result;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioTemplate {
    private static final Logger log = LoggerFactory.getLogger(MinioTemplate.class);
    private MinioClient client;

    public MinioTemplate(MinioProperties minioProperties) {
        try {
            this.client = new MinioClient(minioProperties.getUrl(), minioProperties.getAccessKey(), minioProperties.getSecretKey());
            log.debug("[allbs-utils]:init minio client, current configuration is " + BeanUtil.beanToMap((Object)minioProperties));
        }
        catch (InvalidEndpointException e) {
            log.error("minio client build failed");
        }
        catch (InvalidPortException e) {
            log.error("minio client build failed");
        }
    }

    public void createBucket(String bucketName) {
        if (!this.client.bucketExists(bucketName)) {
            this.client.makeBucket(bucketName);
        }
    }

    public List<Bucket> getAllBuckets() {
        return this.client.listBuckets();
    }

    public Optional<Bucket> getBucket(String bucketName) {
        return this.client.listBuckets().stream().filter(b -> b.name().equals(bucketName)).findFirst();
    }

    public void removeBucket(String bucketName) {
        this.client.removeBucket(bucketName);
    }

    public List<MinioItem> getAllObjectsByPrefix(String bucketName, String prefix, boolean recursive) {
        ArrayList<MinioItem> objectList = new ArrayList<MinioItem>();
        Iterable objectsIterator = this.client.listObjects(bucketName, prefix, recursive);
        for (Result itemResult : objectsIterator) {
            objectList.add(new MinioItem((Item)itemResult.get()));
        }
        return objectList;
    }

    public String getObjectURL(String bucketName, String objectName, Integer expires) {
        return this.client.presignedGetObject(bucketName, objectName, expires);
    }

    public InputStream getObject(String bucketName, String objectName) {
        return this.client.getObject(bucketName, objectName);
    }

    public void putObject(String bucketName, String objectName, InputStream stream) throws Exception {
        this.client.putObject(bucketName, objectName, stream, Long.valueOf(stream.available()), null, null, "application/octet-stream");
    }

    public void putObject(String bucketName, String objectName, InputStream stream, long size, String contextType) throws Exception {
        this.client.putObject(bucketName, objectName, stream, Long.valueOf(size), null, null, contextType);
    }

    public ObjectStat getObjectInfo(String bucketName, String objectName) throws Exception {
        return this.client.statObject(bucketName, objectName);
    }

    public void removeObject(String bucketName, String objectName) throws Exception {
        this.client.removeObject(bucketName, objectName);
    }

    public void removeObjects(String bucketName, List<String> objectNameList) throws Exception {
        this.client.removeObjects(bucketName, objectNameList);
    }
}

