/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.hj212.validator.field;

import cn.allbs.utils.hj212.validator.field.ValidDate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ValidDateValidator
implements ConstraintValidator<ValidDate, String> {
    private String format;
    private boolean optional;

    public void initialize(ValidDate validDate) {
        this.format = validDate.format();
        this.optional = validDate.optional();
    }

    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return this.optional;
        }
        return ValidDateValidator.isValidFormat(this.format, value);
    }

    public static boolean isValidFormat(String format, String value) {
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            if (value != null && !value.equals(sdf.format(date = sdf.parse(value)))) {
                date = null;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date != null;
    }
}

