/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.hj212.validator.field;

import cn.allbs.utils.hj212.validator.field.N;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class NValidator
implements ConstraintValidator<N, String> {
    private int int_len_max;
    private int fraction_len_max;
    private double min;
    private double max;
    private boolean optional;

    public void initialize(N n) {
        this.int_len_max = n.integer();
        this.fraction_len_max = n.fraction();
        this.min = n.min();
        this.max = n.max();
        this.optional = n.optional();
    }

    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return this.optional;
        }
        try {
            boolean result;
            BigDecimal decimal = new BigDecimal(value);
            int int_len = NValidator.getNumLength(decimal.longValue());
            int fraction_len = decimal.scale();
            boolean bl = result = int_len <= this.int_len_max && fraction_len <= this.fraction_len_max;
            if (this.min > 0.0 && decimal.doubleValue() < this.min) {
                return false;
            }
            if (this.max > 0.0 && decimal.doubleValue() > this.max) {
                return false;
            }
            return result;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Deprecated
    public static boolean isValidFormat(String format, String value) {
        Number number = null;
        try {
            DecimalFormat sdf = new DecimalFormat(format);
            if (value != null && !value.equals(sdf.format(number = sdf.parse(value)))) {
                number = null;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return number != null;
    }

    private static int getNumLength(long num) {
        long l = num = num > 0L ? num : -num;
        if (num == 0L) {
            return 1;
        }
        return (int)Math.log10(num) + 1;
    }
}

