/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.hj212.format;

import cn.allbs.utils.hj212.core.Configurator;
import cn.allbs.utils.hj212.core.Configured;
import cn.allbs.utils.hj212.exception.T212FormatException;
import cn.allbs.utils.hj212.format.T212Parser;
import cn.allbs.utils.hj212.format.VerifyUtil;
import cn.allbs.utils.hj212.model.verify.PacketElement;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;

public class T212Generator
implements Configured<T212Generator>,
Closeable {
    public static char[] HEADER = new char[]{'#', '#'};
    public static char[] FOOTER = new char[]{'\r', '\n'};
    protected Writer writer;
    private int generatorFeature;

    public T212Generator(Writer writer) {
        this.writer = writer;
    }

    public void setGeneratorFeature(int generatorFeature) {
        this.generatorFeature = generatorFeature;
    }

    public int writeHeader() throws IOException {
        this.writer.write(HEADER);
        return 2;
    }

    public int writeDataLen(char[] len) throws IOException, T212FormatException {
        VerifyUtil.verifyLen(len.length, 4, PacketElement.DATA_LEN);
        this.writer.write(len);
        return 4;
    }

    public int writeHexInt32(int i) throws IOException {
        char[] intChars = String.format("%04x", i).toCharArray();
        this.writer.write(intChars);
        return intChars.length;
    }

    public int writeData(char[] data) throws IOException {
        this.writer.write(data);
        return data.length;
    }

    public int writeCrc(char[] crc) throws IOException, T212FormatException {
        VerifyUtil.verifyLen(crc.length, 4, PacketElement.DATA_LEN);
        this.writer.write(crc);
        return crc.length;
    }

    public int writeDataAndLenAndCrc(char[] data) throws IOException, T212FormatException {
        int dataLen = data.length;
        char[] len = String.format("%04d", dataLen).toCharArray();
        this.writer.write(len);
        VerifyUtil.verifyLen(len.length, 4, PacketElement.DATA_CRC);
        this.writer.write(data);
        int crc = T212Parser.crc16Checkout(data, dataLen);
        int crcLen = this.writeHexInt32(crc);
        VerifyUtil.verifyLen(crcLen, 4, PacketElement.DATA_CRC);
        return len.length + data.length + crcLen;
    }

    public int writeFooter() throws IOException {
        this.writer.write(FOOTER);
        return 2;
    }

    @Override
    public void configured(Configurator<T212Generator> configurator) {
        configurator.config(this);
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

