/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.hj212.enums;

import cn.allbs.utils.hj212.translator.CodeMean;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public enum CommandType implements CodeMean
{
    REQUEST("\u8bf7\u6c42\u547d\u4ee4", "[1]\\d{3}"),
    UPLOAD("\u4e0a\u4f20\u547d\u4ee4", "[2]\\d{3}"),
    NOTICE("\u901a\u77e5\u547d\u4ee4", "[3]\\d{3}"),
    SHELL("\u4ea4\u4e92\u547d\u4ee4", "[9]\\d{3}"),
    UNKNOW("\u672a\u77e5", "\\d{4}", 10000);

    private String code;
    private String meaning;
    private String pattern;
    private Predicate<String> predicate;
    private int order;

    private CommandType(String meaning, String pattern) {
        this.code = this.name();
        this.meaning = meaning;
        this.pattern = pattern;
        this.predicate = Pattern.compile(this.pattern).asPredicate();
        this.order = this.ordinal();
    }

    private CommandType(String meaning, String pattern, int order) {
        this.code = this.name();
        this.meaning = meaning;
        this.pattern = pattern;
        this.predicate = Pattern.compile(this.pattern).asPredicate();
        this.order = order;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public String mean() {
        return this.meaning;
    }

    public String getCode() {
        return this.code;
    }

    public String getMeaning() {
        return this.meaning;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Predicate<String> getPredicate() {
        return this.predicate;
    }

    public int getOrder() {
        return this.order;
    }

    private CommandType(String code, String meaning, String pattern, Predicate<String> predicate, int order) {
        this.code = code;
        this.meaning = meaning;
        this.pattern = pattern;
        this.predicate = predicate;
        this.order = order;
    }
}

