/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.hj212.deser;

import cn.allbs.utils.hj212.config.SegmentParser;
import cn.allbs.utils.hj212.config.SegmentToken;
import cn.allbs.utils.hj212.deser.SegmentDeserializer;
import cn.allbs.utils.hj212.deser.StringSegmentDeserializer;
import cn.allbs.utils.hj212.exception.SegmentFormatException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class StringMapSegmentDeserializer
implements SegmentDeserializer<Map<String, String>> {
    protected final SegmentDeserializer<String> _valueDeserializer = new StringSegmentDeserializer();

    @Override
    public Map<String, String> deserialize(SegmentParser parser) throws IOException, SegmentFormatException {
        if (parser.currentToken() == null) {
            parser.initToken();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        this.readMap(parser, result);
        return result;
    }

    private void readMap(SegmentParser parser, Map<String, String> result) throws IOException, SegmentFormatException {
        String key = parser.readKey();
        while (key != null) {
            SegmentToken token = parser.currentToken();
            String value = null;
            switch (token) {
                case NOT_AVAILABLE: {
                    return;
                }
                case END_PART_KEY: {
                    assert (false);
                }
                case END_SUB_ENTRY: 
                case END_ENTRY: 
                case END_OBJECT_VALUE: {
                    break;
                }
                case END_KEY: 
                case START_OBJECT_VALUE: {
                    value = this._valueDeserializer.deserialize(parser);
                }
            }
            result.put(key, value);
            key = parser.readKey();
        }
    }
}

