/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.hj212.deser;

import cn.allbs.utils.hj212.config.SegmentParser;
import cn.allbs.utils.hj212.core.Configurator;
import cn.allbs.utils.hj212.core.Configured;
import cn.allbs.utils.hj212.deser.SegmentDeserializer;
import cn.allbs.utils.hj212.deser.T212Deserializer;
import cn.allbs.utils.hj212.enums.HjDataFlag;
import cn.allbs.utils.hj212.exception.SegmentFormatException;
import cn.allbs.utils.hj212.exception.T212FormatException;
import cn.allbs.utils.hj212.feature.VerifyFeature;
import cn.allbs.utils.hj212.format.T212Parser;
import cn.allbs.utils.hj212.format.VerifyUtil;
import cn.allbs.utils.hj212.model.verify.DataElement;
import cn.allbs.utils.hj212.model.verify.PacketElement;
import cn.allbs.utils.hj212.model.verify.T212DataLevelMap;
import cn.allbs.utils.hj212.model.verify.T212Map;
import cn.allbs.utils.hj212.model.verify.T212MapEntry;
import cn.allbs.utils.hj212.model.verify.groups.ModeGroup;
import cn.allbs.utils.hj212.model.verify.groups.T212MapLevelGroup;
import cn.allbs.utils.hj212.model.verify.groups.VersionGroup;
import cn.allbs.utils.hj212.validator.clazz.FieldValidator;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;

public class DataLevelMapDeserializer
implements T212Deserializer<Map<String, String>>,
Configured<DataLevelMapDeserializer> {
    private int verifyFeature;
    private Configurator<SegmentParser> segmentParserConfigurator;
    private SegmentDeserializer<Map<String, String>> segmentDeserializer;
    private Validator validator;

    @Override
    public void configured(Configurator<DataLevelMapDeserializer> configurator) {
        configurator.config(this);
    }

    @Override
    public Map<String, String> deserialize(T212Parser parser) throws IOException, T212FormatException {
        parser.readHeader();
        int len = parser.readInt32(10);
        if (len == -1) {
            T212FormatException.length_not_range(PacketElement.DATA_LEN, len, 4, 4);
        }
        if (VerifyFeature.DATA_LEN_RANGE.enabledIn(this.verifyFeature)) {
            VerifyUtil.verifyRange(len, 0, 1024, PacketElement.DATA_LEN);
        }
        char[] data = parser.readData(len);
        int crc = parser.readInt32(16);
        if (VerifyFeature.DATA_CRC.enabledIn(this.verifyFeature) && (crc == -1 || T212Parser.crc16Checkout(data, len) != crc)) {
            T212FormatException.crc_verification_failed(PacketElement.DATA, data, crc);
        }
        return this.deserialize(data);
    }

    public Map<String, String> deserialize(char[] data) throws IOException, T212FormatException {
        PushbackReader reader = new PushbackReader(new CharArrayReader(data));
        SegmentParser parser = new SegmentParser(reader);
        parser.configured(this.segmentParserConfigurator);
        Map<String, String> result = null;
        try {
            result = this.segmentDeserializer.deserialize(parser);
        }
        catch (SegmentFormatException e) {
            T212FormatException.segment_exception(e);
        }
        if (VerifyFeature.USE_VERIFICATION.enabledIn(this.verifyFeature)) {
            this.verifyByType(result);
        }
        return result;
    }

    private void verifyByType(Map<String, String> result) throws T212FormatException {
        Set constraintViolationSet;
        T212DataLevelMap t212Map = T212Map.createDataLevel(result);
        ArrayList<Class> groups = new ArrayList<Class>();
        groups.add(Default.class);
        int flag = 0;
        if (result.containsKey(DataElement.Flag.name())) {
            String f = result.get(DataElement.Flag.name());
            flag = Integer.valueOf(f);
        }
        if (HjDataFlag.V0.isMarked(flag)) {
            groups.add(VersionGroup.V2017.class);
        } else {
            groups.add(VersionGroup.V2005.class);
        }
        if (HjDataFlag.D.isMarked(flag)) {
            groups.add(ModeGroup.UseSubPacket.class);
        }
        if (!(constraintViolationSet = this.validator.validate((Object)t212Map, groups.toArray(new Class[0]))).isEmpty() && VerifyFeature.THROW_ERROR_VERIFICATION_FAILED.enabledIn(this.verifyFeature)) {
            FieldValidator.create_format_exception(constraintViolationSet, result);
        }
    }

    @Deprecated
    private void verifyByVersion(Map<String, String> result) throws T212FormatException {
        Set constraintViolationSet;
        ArrayList<Class<ModeGroup.UseSubPacket>> groups = new ArrayList<Class<ModeGroup.UseSubPacket>>();
        groups.add(Default.class);
        groups.add(T212MapLevelGroup.DataLevel.class);
        int flag = 0;
        if (result.containsKey(DataElement.Flag.name())) {
            String f = result.get(DataElement.Flag.name());
            flag = Integer.valueOf(f);
        }
        T212Map<String, String> t212Map = HjDataFlag.V0.isMarked(flag) ? T212Map.create2017(result) : T212Map.create2005(result);
        if (HjDataFlag.D.isMarked(flag)) {
            groups.add(ModeGroup.UseSubPacket.class);
        }
        if (!(constraintViolationSet = this.validator.validate(t212Map, groups.toArray(new Class[0]))).isEmpty()) {
            FieldValidator.create_format_exception(constraintViolationSet, result);
        }
    }

    @Deprecated
    private void verify(Map<String, String> result) throws T212FormatException {
        if (!VerifyFeature.ALLOW_MISSING_FIELD.enabledIn(this.verifyFeature)) {
            Optional<DataElement> missing;
            String f;
            int flag;
            Stream<DataElement> stream = Stream.of(DataElement.values()).filter(DataElement::isRequired);
            if (result.containsKey(DataElement.Flag.name()) && HjDataFlag.D.isMarked(flag = Integer.valueOf(f = result.get(DataElement.Flag.name())).intValue())) {
                stream = Stream.concat(stream, Stream.of(DataElement.PNO, DataElement.PNUM));
            }
            if ((missing = stream.filter(e -> !result.containsKey(e.name())).findFirst()).isPresent()) {
                T212FormatException.field_is_missing(PacketElement.DATA, missing.get().name());
            }
        }
        if (!VerifyFeature.ALLOW_VALUE_NOT_IN_RANGE.enabledIn(this.verifyFeature)) {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Stream<Set> v = result.entrySet().stream().map(kv -> T212MapEntry.of((String)kv.getKey(), (String)kv.getValue())).map(e -> validator.validate(e, new Class[]{DataElement.valueOf(e.getKey()).group()}));
            Set constraintViolationSet = VerifyFeature.STRICT.enabledIn(this.verifyFeature) ? v.flatMap(Collection::stream).collect(Collectors.toSet()) : (Set)v.findAny().orElse(new HashSet());
            if (!constraintViolationSet.isEmpty()) {
                String msg = constraintViolationSet.stream().map(cv -> ((T212MapEntry)cv.getRootBean()).getKey() + ":" + cv.getInvalidValue().toString() + "_" + cv.getMessage()).collect(Collectors.joining("\n"));
                throw new T212FormatException("Validate error\n\n" + msg);
            }
        }
    }

    public void setVerifyFeature(int verifyFeature) {
        this.verifyFeature = verifyFeature;
    }

    public void setSegmentParserConfigurator(Configurator<SegmentParser> segmentParserConfigurator) {
        this.segmentParserConfigurator = segmentParserConfigurator;
    }

    public void setSegmentDeserializer(SegmentDeserializer<Map<String, String>> segmentDeserializer) {
        this.segmentDeserializer = segmentDeserializer;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }
}

