/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.hj212.core;

import cn.allbs.utils.hj212.core.MapEntryStepGenerator;
import cn.allbs.utils.hj212.core.ReaderMatch;
import cn.allbs.utils.hj212.core.ReaderStream;
import cn.allbs.utils.hj212.lambda.RunnableWithThrowable;
import cn.allbs.utils.hj212.lambda.SupplierWithThrowable;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class SingleCharMatch<ParentStream extends ReaderStream>
implements ReaderMatch<SingleCharMatch<ParentStream>, ParentStream, Character> {
    private ParentStream parentStream;
    private PushbackReader reader;
    private Map<Predicate<Character>, SupplierWithThrowable<Optional<Object>, IOException>> map;
    private MapEntryStepGenerator<Predicate<Character>, SupplierWithThrowable<Optional<Object>, IOException>> generator;

    public SingleCharMatch(ParentStream parentStream) {
        this.parentStream = parentStream;
        this.reader = ((ReaderStream)parentStream).reader();
        this.map = new LinkedHashMap<Predicate<Character>, SupplierWithThrowable<Optional<Object>, IOException>>();
        MapEntryStepGenerator.Builder<Predicate, SupplierWithThrowable> builder = MapEntryStepGenerator.builder();
        this.generator = builder.consumer((k, v) -> this.map.put((Predicate<Character>)k, (SupplierWithThrowable<Optional<Object>, IOException>)v)).keyDefault(() -> character -> false).keyMergeOperator(Predicate::or).valueMergeOperator((thisRunnable, runnable) -> () -> {
            Optional o = (Optional)thisRunnable.get();
            if (!o.isPresent()) {
                o = (Optional)runnable.get();
            }
            return o;
        }).create();
    }

    public SingleCharMatch<ParentStream> when(Predicate<Character> predicate) {
        this.generator.putKey(predicate);
        return this;
    }

    public SingleCharMatch<ParentStream> when(int character) {
        this.generator.putKey(c -> c.charValue() == character);
        return this;
    }

    public SingleCharMatch<ParentStream> when(Character character) {
        this.generator.putKey(c -> c == character);
        return this;
    }

    public SingleCharMatch<ParentStream> then(Supplier<IOException> exceptionSupplier) {
        this.generator.putValue(() -> {
            throw (IOException)exceptionSupplier.get();
        });
        return this;
    }

    public SingleCharMatch<ParentStream> then(SupplierWithThrowable<Optional<Object>, IOException> runnable) {
        this.generator.putValue(runnable);
        return this;
    }

    public SingleCharMatch<ParentStream> then(RunnableWithThrowable<IOException> runnable) {
        this.generator.putValue(() -> {
            runnable.run();
            return Optional.of(true);
        });
        return this;
    }

    public SingleCharMatch<ParentStream> skip() {
        this.generator.putValue(() -> Optional.of(true));
        return this;
    }

    public ReaderStream<SingleCharMatch<ParentStream>> then() {
        ReaderStream<SingleCharMatch<ParentStream>> reader = new ReaderStream<SingleCharMatch<ParentStream>>(this.reader, ((ReaderStream)this.parentStream).bufSize() - 1, this);
        this.then(reader::match);
        return reader;
    }

    @Override
    public ParentStream done() {
        this.generator.generate();
        return this.parentStream;
    }

    @Override
    public Optional<Character> match() throws IOException {
        int i = this.reader.read();
        Character character = Character.valueOf((char)i);
        Optional<SupplierWithThrowable> r = this.map.entrySet().stream().filter(kv -> ((Predicate)kv.getKey()).test(character)).map(Map.Entry::getValue).findAny();
        if (r.isPresent() && ((Optional)r.get().get()).isPresent()) {
            return Optional.of(character);
        }
        this.reader.unread(i);
        return Optional.empty();
    }

    public String toString() {
        return ((ReaderStream)this.parentStream).toString() + "/" + this.getClass().getSimpleName() + "(" + this.map.size() + ")";
    }
}

