/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.hj212.config;

import cn.allbs.utils.hj212.config.SegmentGenerator;
import cn.allbs.utils.hj212.config.SegmentParser;
import cn.allbs.utils.hj212.converter.DataConverter;
import cn.allbs.utils.hj212.converter.DataReverseConverter;
import cn.allbs.utils.hj212.core.Configurator;
import cn.allbs.utils.hj212.core.MultipleConfiguratorAdapter;
import cn.allbs.utils.hj212.deser.CpDataLevelMapDeserializer;
import cn.allbs.utils.hj212.deser.DataDeserializer;
import cn.allbs.utils.hj212.deser.DataLevelMapDeserializer;
import cn.allbs.utils.hj212.deser.MapSegmentDeserializer;
import cn.allbs.utils.hj212.deser.PackLevelDeserializer;
import cn.allbs.utils.hj212.deser.StringMapSegmentDeserializer;
import cn.allbs.utils.hj212.format.T212Generator;
import cn.allbs.utils.hj212.format.T212Parser;
import cn.allbs.utils.hj212.ser.CpDataLevelMapDataSerializer;
import cn.allbs.utils.hj212.ser.DataSerializer;
import cn.allbs.utils.hj212.ser.MapSegmentSerializer;
import cn.allbs.utils.hj212.ser.PackLevelSerializer;
import cn.allbs.utils.hj212.ser.T212CpMapPathValueSegmentSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Validator;

public class T212Configurator
extends MultipleConfiguratorAdapter {
    private int segmentParserFeature;
    private int parserFeature;
    private int verifyFeature;
    private Validator validator;
    private ObjectMapper objectMapper;
    private int segmentGeneratorFeature;
    private final int generatorFeature = 0;

    public void setSegmentParserFeature(int segmentParserFeature) {
        this.segmentParserFeature = segmentParserFeature;
    }

    public void setParserFeature(int parserFeature) {
        this.parserFeature = parserFeature;
    }

    public void setVerifyFeature(int verifyFeature) {
        this.verifyFeature = verifyFeature;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setSegmentGeneratorFeature(int segmentGeneratorFeature) {
        this.segmentGeneratorFeature = segmentGeneratorFeature;
    }

    @Override
    public Collection<Configurator> configurators() {
        return Stream.of(new SegmentParserConfigurator(), new T212ParserConfigurator(), new PackLevelDeserializerConfigurator(), new DataLevelMapDeserializerConfigurator(), new CpDataLevelMapDeserializerConfigurator(), new DataDeserializerConfigurator(), new DataConverterConfigurator(), new SegmentGeneratorConfigurator(), new T212GeneratorConfigurator(), new PackLevelSerializerConfigurator(), new CpDataLevelMapDataSerializerConfigurator(), new DataSerializerConfigurator(), new DataReverseConverterConfigurator()).collect(Collectors.toSet());
    }

    public void configure(SegmentParser parser) {
        if (parser.currentToken() == null) {
            parser.initToken();
        }
        parser.setParserFeature(this.segmentParserFeature);
    }

    public void configure(T212Parser parser) {
        parser.setParserFeature(this.parserFeature);
    }

    public void configure(PackLevelDeserializer deserializer) {
        deserializer.setVerifyFeature(this.verifyFeature);
        deserializer.setParserConfigurator(this::configure);
    }

    public void configure(DataLevelMapDeserializer deserializer) {
        deserializer.setVerifyFeature(this.verifyFeature);
        deserializer.setValidator(this.validator);
        deserializer.setSegmentParserConfigurator(this::configure);
        deserializer.setSegmentDeserializer(new StringMapSegmentDeserializer());
    }

    public void configure(CpDataLevelMapDeserializer deserializer) {
        deserializer.setVerifyFeature(this.verifyFeature);
        deserializer.setValidator(this.validator);
        deserializer.setSegmentParserConfigurator(this::configure);
        deserializer.setSegmentDeserializer(new MapSegmentDeserializer());
    }

    public void configure(DataDeserializer deserializer) {
        deserializer.setVerifyFeature(this.verifyFeature);
        deserializer.setValidator(this.validator);
        deserializer.setSegmentParserConfigurator(this::configure);
        deserializer.setSegmentDeserializer(new MapSegmentDeserializer());
        deserializer.setDataConverterConfigurator(this::configure);
    }

    public void configure(DataConverter dataConverter) {
        ObjectMapper objectMapper = this.objectMapper;
        if (objectMapper == null) {
            objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        dataConverter.setObjectMapper(objectMapper);
    }

    private void configure(SegmentGenerator generator) {
        if (generator.nextToken() == null) {
            generator.initToken();
        }
        generator.setGeneratorFeature(this.segmentGeneratorFeature);
    }

    private void configure(T212Generator generator) {
        generator.setGeneratorFeature(0);
    }

    private void configure(PackLevelSerializer serializer) {
        serializer.setVerifyFeature(this.verifyFeature);
        serializer.setGeneratorConfigurator(this::configure);
    }

    public void configure(CpDataLevelMapDataSerializer serializer) {
        serializer.setVerifyFeature(this.verifyFeature);
        serializer.setValidator(this.validator);
        serializer.setSegmentGeneratorConfigurator(this::configure);
        serializer.setSegmentSerializer(new MapSegmentSerializer(new T212CpMapPathValueSegmentSerializer()));
    }

    private void configure(DataSerializer serializer) {
        serializer.setVerifyFeature(this.verifyFeature);
        serializer.setValidator(this.validator);
        serializer.setSegmentGeneratorConfigurator(this::configure);
        serializer.setSegmentSerializer(new MapSegmentSerializer(new T212CpMapPathValueSegmentSerializer()));
        serializer.setDataReverseConverterConfigurator(this::configure);
    }

    private void configure(DataReverseConverter dataReverseConverter) {
        ObjectMapper objectMapper = this.objectMapper;
        if (objectMapper == null) {
            objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        dataReverseConverter.setObjectMapper(objectMapper);
    }

    class DataReverseConverterConfigurator
    implements Configurator<DataReverseConverter> {
        DataReverseConverterConfigurator() {
        }

        @Override
        public void config(DataReverseConverter converter) {
            T212Configurator.this.configure(converter);
        }
    }

    class DataSerializerConfigurator
    implements Configurator<DataSerializer> {
        DataSerializerConfigurator() {
        }

        @Override
        public void config(DataSerializer serializer) {
            T212Configurator.this.configure(serializer);
        }
    }

    class CpDataLevelMapDataSerializerConfigurator
    implements Configurator<CpDataLevelMapDataSerializer> {
        CpDataLevelMapDataSerializerConfigurator() {
        }

        @Override
        public void config(CpDataLevelMapDataSerializer serializer) {
            T212Configurator.this.configure(serializer);
        }
    }

    class PackLevelSerializerConfigurator
    implements Configurator<PackLevelSerializer> {
        PackLevelSerializerConfigurator() {
        }

        @Override
        public void config(PackLevelSerializer serializer) {
            T212Configurator.this.configure(serializer);
        }
    }

    class T212GeneratorConfigurator
    implements Configurator<T212Generator> {
        T212GeneratorConfigurator() {
        }

        @Override
        public void config(T212Generator generator) {
            T212Configurator.this.configure(generator);
        }
    }

    class SegmentGeneratorConfigurator
    implements Configurator<SegmentGenerator> {
        SegmentGeneratorConfigurator() {
        }

        @Override
        public void config(SegmentGenerator generator) {
            T212Configurator.this.configure(generator);
        }
    }

    class DataConverterConfigurator
    implements Configurator<DataConverter> {
        DataConverterConfigurator() {
        }

        @Override
        public void config(DataConverter converter) {
            T212Configurator.this.configure(converter);
        }
    }

    class DataDeserializerConfigurator
    implements Configurator<DataDeserializer> {
        DataDeserializerConfigurator() {
        }

        @Override
        public void config(DataDeserializer deserializer) {
            T212Configurator.this.configure(deserializer);
        }
    }

    class CpDataLevelMapDeserializerConfigurator
    implements Configurator<CpDataLevelMapDeserializer> {
        CpDataLevelMapDeserializerConfigurator() {
        }

        @Override
        public void config(CpDataLevelMapDeserializer deserializer) {
            T212Configurator.this.configure(deserializer);
        }
    }

    class DataLevelMapDeserializerConfigurator
    implements Configurator<DataLevelMapDeserializer> {
        DataLevelMapDeserializerConfigurator() {
        }

        @Override
        public void config(DataLevelMapDeserializer deserializer) {
            T212Configurator.this.configure(deserializer);
        }
    }

    class PackLevelDeserializerConfigurator
    implements Configurator<PackLevelDeserializer> {
        PackLevelDeserializerConfigurator() {
        }

        @Override
        public void config(PackLevelDeserializer deserializer) {
            T212Configurator.this.configure(deserializer);
        }
    }

    class T212ParserConfigurator
    implements Configurator<T212Parser> {
        T212ParserConfigurator() {
        }

        @Override
        public void config(T212Parser parser) {
            T212Configurator.this.configure(parser);
        }
    }

    class SegmentParserConfigurator
    implements Configurator<SegmentParser> {
        SegmentParserConfigurator() {
        }

        @Override
        public void config(SegmentParser parser) {
            T212Configurator.this.configure(parser);
        }
    }
}

