/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.excel.handle;

import cn.allbs.utils.annotation.ExportExcel;
import cn.allbs.utils.excel.ExcelConfigProperties;
import cn.allbs.utils.excel.exception.ExcelException;
import cn.allbs.utils.excel.handle.AbstractSheetWriteHandler;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.ObjectProvider;

public class ManySheetWriteHandler
extends AbstractSheetWriteHandler {
    private final ExcelConfigProperties configProperties;
    private final ObjectProvider<List<Converter<?>>> converterProvider;

    @Override
    public boolean support(Object obj) {
        if (obj instanceof List) {
            List objList = (List)obj;
            return !objList.isEmpty() && objList.get(0) instanceof List;
        }
        throw new ExcelException("@ExportExcel \u8fd4\u56de\u503c\u5fc5\u987b\u4e3aList\u7c7b\u578b");
    }

    @Override
    public void write(Object obj, HttpServletResponse response, ExportExcel exportExcel) {
        List objList = (List)obj;
        ExcelWriter excelWriter = this.getExcelWriter(response, exportExcel, this.configProperties.getTemplatePath());
        String[] sheets = exportExcel.sheet();
        for (int i = 0; i < sheets.length; ++i) {
            List eleList = (List)objList.get(i);
            Class<?> dataClass = eleList.get(0).getClass();
            WriteSheet sheet = this.sheet(i, exportExcel.sheet()[i], dataClass, exportExcel.template(), exportExcel.headGenerator());
            excelWriter.write((List)objList.get(i), sheet);
        }
        excelWriter.finish();
    }

    @Override
    public void registerCustomConverter(ExcelWriterBuilder builder) {
        this.converterProvider.ifAvailable(converters -> converters.forEach(arg_0 -> ((ExcelWriterBuilder)builder).registerConverter(arg_0)));
    }

    public ManySheetWriteHandler(ExcelConfigProperties configProperties, ObjectProvider<List<Converter<?>>> converterProvider) {
        this.configProperties = configProperties;
        this.converterProvider = converterProvider;
    }
}

