/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.excel.handle;

import cn.allbs.utils.annotation.ExportExcel;
import cn.allbs.utils.excel.convert.LocalDateStringConverter;
import cn.allbs.utils.excel.convert.LocalDateTimeStringConverter;
import cn.allbs.utils.excel.convert.TimestampStringConverter;
import cn.allbs.utils.excel.exception.ExcelException;
import cn.allbs.utils.excel.handle.SheetWriteHandler;
import cn.allbs.utils.excel.head.HeadGenerator;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public abstract class AbstractSheetWriteHandler
implements SheetWriteHandler {
    @Override
    public void check(ExportExcel exportExcel) {
        if (!StringUtils.hasText((String)exportExcel.name())) {
            throw new ExcelException("@ExportExcel name \u914d\u7f6e\u4e0d\u5408\u6cd5");
        }
        if (exportExcel.sheet().length == 0) {
            throw new ExcelException("@ExportExcel sheet \u914d\u7f6e\u4e0d\u5408\u6cd5");
        }
    }

    @Override
    public void export(Object o, HttpServletResponse response, ExportExcel exportExcel) {
        this.check(exportExcel);
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        String name = (String)Objects.requireNonNull(requestAttributes).getAttribute("__EXCEL_NAME_KEY__", 0);
        String fileName = String.format("%s%s", URLEncoder.encode(name, "UTF-8"), exportExcel.suffix().getValue());
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        this.write(o, response, exportExcel);
    }

    public ExcelWriter getExcelWriter(HttpServletResponse response, ExportExcel exportExcel, String templatePath) {
        ExcelWriterBuilder writerBuilder = ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream()).registerConverter((Converter)LocalDateStringConverter.INSTANCE)).registerConverter((Converter)LocalDateTimeStringConverter.INSTANCE)).registerConverter((Converter)TimestampStringConverter.INSTANCE)).autoCloseStream(Boolean.valueOf(true)).excelType(exportExcel.suffix()).inMemory(Boolean.valueOf(exportExcel.inMemory()));
        if (StringUtils.hasText((String)exportExcel.password())) {
            writerBuilder.password(exportExcel.password());
        }
        if (exportExcel.include().length != 0) {
            writerBuilder.includeColumnFiledNames(Arrays.asList(exportExcel.include()));
        }
        if (exportExcel.exclude().length != 0) {
            writerBuilder.excludeColumnFiledNames(Arrays.asList(exportExcel.include()));
        }
        if (exportExcel.writeHandler().length != 0) {
            for (Class<? extends WriteHandler> clazz : exportExcel.writeHandler()) {
                writerBuilder.registerWriteHandler((WriteHandler)BeanUtils.instantiateClass(clazz));
            }
        }
        this.registerCustomConverter(writerBuilder);
        if (exportExcel.converter().length != 0) {
            for (Class<? extends WriteHandler> clazz : exportExcel.converter()) {
                writerBuilder.registerConverter((Converter)BeanUtils.instantiateClass(clazz));
            }
        }
        if (StringUtils.hasText((String)exportExcel.template())) {
            ClassPathResource classPathResource = new ClassPathResource(templatePath + File.separator + exportExcel.template());
            InputStream inputStream = classPathResource.getInputStream();
            writerBuilder.withTemplate(inputStream);
        }
        return writerBuilder.build();
    }

    public void registerCustomConverter(ExcelWriterBuilder builder) {
    }

    public WriteSheet sheet(Integer sheetNo, String sheetName, Class<?> dataClass, String template, Class<? extends HeadGenerator> headEnhancerClass) {
        ExcelWriterSheetBuilder excelWriterSheetBuilder;
        HeadGenerator headGenerator = null;
        if (!headEnhancerClass.isInterface()) {
            headGenerator = (HeadGenerator)BeanUtils.instantiateClass(headEnhancerClass);
        }
        ExcelWriterSheetBuilder excelWriterSheetBuilder2 = excelWriterSheetBuilder = StringUtils.hasText((String)template) ? EasyExcel.writerSheet((Integer)sheetNo) : EasyExcel.writerSheet((Integer)sheetNo, (String)sheetName);
        if (headGenerator != null) {
            excelWriterSheetBuilder.head(headGenerator.head(dataClass));
        } else if (dataClass != null) {
            excelWriterSheetBuilder.head(dataClass);
        }
        return excelWriterSheetBuilder.build();
    }
}

